package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LDAPIdentityProviderFluent<A extends LDAPIdentityProviderFluent<A>> extends BaseFluent<A>{
  public LDAPIdentityProviderFluent() {
  }
  
  public LDAPIdentityProviderFluent(LDAPIdentityProvider instance) {
    this.copyInstance(instance);
  }
  private LDAPAttributeMappingBuilder attributes;
  private String bindDN;
  private SecretNameReferenceBuilder bindPassword;
  private ConfigMapNameReferenceBuilder ca;
  private Boolean insecure;
  private String url;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(LDAPIdentityProvider instance) {
    instance = (instance != null ? instance : new LDAPIdentityProvider());
    if (instance != null) {
          this.withAttributes(instance.getAttributes());
          this.withBindDN(instance.getBindDN());
          this.withBindPassword(instance.getBindPassword());
          this.withCa(instance.getCa());
          this.withInsecure(instance.getInsecure());
          this.withUrl(instance.getUrl());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LDAPAttributeMapping buildAttributes() {
    return this.attributes != null ? this.attributes.build() : null;
  }
  
  public A withAttributes(LDAPAttributeMapping attributes) {
    this._visitables.remove("attributes");
    if (attributes != null) {
        this.attributes = new LDAPAttributeMappingBuilder(attributes);
        this._visitables.get("attributes").add(this.attributes);
    } else {
        this.attributes = null;
        this._visitables.get("attributes").remove(this.attributes);
    }
    return (A) this;
  }
  
  public boolean hasAttributes() {
    return this.attributes != null;
  }
  
  public AttributesNested<A> withNewAttributes() {
    return new AttributesNested(null);
  }
  
  public AttributesNested<A> withNewAttributesLike(LDAPAttributeMapping item) {
    return new AttributesNested(item);
  }
  
  public AttributesNested<A> editAttributes() {
    return withNewAttributesLike(java.util.Optional.ofNullable(buildAttributes()).orElse(null));
  }
  
  public AttributesNested<A> editOrNewAttributes() {
    return withNewAttributesLike(java.util.Optional.ofNullable(buildAttributes()).orElse(new LDAPAttributeMappingBuilder().build()));
  }
  
  public AttributesNested<A> editOrNewAttributesLike(LDAPAttributeMapping item) {
    return withNewAttributesLike(java.util.Optional.ofNullable(buildAttributes()).orElse(item));
  }
  
  public String getBindDN() {
    return this.bindDN;
  }
  
  public A withBindDN(String bindDN) {
    this.bindDN = bindDN;
    return (A) this;
  }
  
  public boolean hasBindDN() {
    return this.bindDN != null;
  }
  
  public SecretNameReference buildBindPassword() {
    return this.bindPassword != null ? this.bindPassword.build() : null;
  }
  
  public A withBindPassword(SecretNameReference bindPassword) {
    this._visitables.remove("bindPassword");
    if (bindPassword != null) {
        this.bindPassword = new SecretNameReferenceBuilder(bindPassword);
        this._visitables.get("bindPassword").add(this.bindPassword);
    } else {
        this.bindPassword = null;
        this._visitables.get("bindPassword").remove(this.bindPassword);
    }
    return (A) this;
  }
  
  public boolean hasBindPassword() {
    return this.bindPassword != null;
  }
  
  public A withNewBindPassword(String name) {
    return (A)withBindPassword(new SecretNameReference(name));
  }
  
  public BindPasswordNested<A> withNewBindPassword() {
    return new BindPasswordNested(null);
  }
  
  public BindPasswordNested<A> withNewBindPasswordLike(SecretNameReference item) {
    return new BindPasswordNested(item);
  }
  
  public BindPasswordNested<A> editBindPassword() {
    return withNewBindPasswordLike(java.util.Optional.ofNullable(buildBindPassword()).orElse(null));
  }
  
  public BindPasswordNested<A> editOrNewBindPassword() {
    return withNewBindPasswordLike(java.util.Optional.ofNullable(buildBindPassword()).orElse(new SecretNameReferenceBuilder().build()));
  }
  
  public BindPasswordNested<A> editOrNewBindPasswordLike(SecretNameReference item) {
    return withNewBindPasswordLike(java.util.Optional.ofNullable(buildBindPassword()).orElse(item));
  }
  
  public ConfigMapNameReference buildCa() {
    return this.ca != null ? this.ca.build() : null;
  }
  
  public A withCa(ConfigMapNameReference ca) {
    this._visitables.remove("ca");
    if (ca != null) {
        this.ca = new ConfigMapNameReferenceBuilder(ca);
        this._visitables.get("ca").add(this.ca);
    } else {
        this.ca = null;
        this._visitables.get("ca").remove(this.ca);
    }
    return (A) this;
  }
  
  public boolean hasCa() {
    return this.ca != null;
  }
  
  public A withNewCa(String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  
  public CaNested<A> withNewCa() {
    return new CaNested(null);
  }
  
  public CaNested<A> withNewCaLike(ConfigMapNameReference item) {
    return new CaNested(item);
  }
  
  public CaNested<A> editCa() {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(null));
  }
  
  public CaNested<A> editOrNewCa() {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  
  public CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(item));
  }
  
  public Boolean getInsecure() {
    return this.insecure;
  }
  
  public A withInsecure(Boolean insecure) {
    this.insecure = insecure;
    return (A) this;
  }
  
  public boolean hasInsecure() {
    return this.insecure != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LDAPIdentityProviderFluent that = (LDAPIdentityProviderFluent) o;
    if (!java.util.Objects.equals(attributes, that.attributes)) return false;
    if (!java.util.Objects.equals(bindDN, that.bindDN)) return false;
    if (!java.util.Objects.equals(bindPassword, that.bindPassword)) return false;
    if (!java.util.Objects.equals(ca, that.ca)) return false;
    if (!java.util.Objects.equals(insecure, that.insecure)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(attributes,  bindDN,  bindPassword,  ca,  insecure,  url,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attributes != null) { sb.append("attributes:"); sb.append(attributes + ","); }
    if (bindDN != null) { sb.append("bindDN:"); sb.append(bindDN + ","); }
    if (bindPassword != null) { sb.append("bindPassword:"); sb.append(bindPassword + ","); }
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (insecure != null) { sb.append("insecure:"); sb.append(insecure + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecure() {
    return withInsecure(true);
  }
  public class AttributesNested<N> extends LDAPAttributeMappingFluent<AttributesNested<N>> implements Nested<N>{
    AttributesNested(LDAPAttributeMapping item) {
      this.builder = new LDAPAttributeMappingBuilder(this, item);
    }
    LDAPAttributeMappingBuilder builder;
    
    public N and() {
      return (N) LDAPIdentityProviderFluent.this.withAttributes(builder.build());
    }
    
    public N endAttributes() {
      return and();
    }
    
  
  }
  public class BindPasswordNested<N> extends SecretNameReferenceFluent<BindPasswordNested<N>> implements Nested<N>{
    BindPasswordNested(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    SecretNameReferenceBuilder builder;
    
    public N and() {
      return (N) LDAPIdentityProviderFluent.this.withBindPassword(builder.build());
    }
    
    public N endBindPassword() {
      return and();
    }
    
  
  }
  public class CaNested<N> extends ConfigMapNameReferenceFluent<CaNested<N>> implements Nested<N>{
    CaNested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    
    public N and() {
      return (N) LDAPIdentityProviderFluent.this.withCa(builder.build());
    }
    
    public N endCa() {
      return and();
    }
    
  
  }

}