package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Float;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KubeClientConfigFluent<A extends KubeClientConfigFluent<A>> extends BaseFluent<A>{
  public KubeClientConfigFluent() {
  }
  
  public KubeClientConfigFluent(KubeClientConfig instance) {
    this.copyInstance(instance);
  }
  private ClientConnectionOverridesBuilder connectionOverrides;
  private String kubeConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KubeClientConfig instance) {
    instance = (instance != null ? instance : new KubeClientConfig());
    if (instance != null) {
          this.withConnectionOverrides(instance.getConnectionOverrides());
          this.withKubeConfig(instance.getKubeConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ClientConnectionOverrides buildConnectionOverrides() {
    return this.connectionOverrides != null ? this.connectionOverrides.build() : null;
  }
  
  public A withConnectionOverrides(ClientConnectionOverrides connectionOverrides) {
    this._visitables.remove("connectionOverrides");
    if (connectionOverrides != null) {
        this.connectionOverrides = new ClientConnectionOverridesBuilder(connectionOverrides);
        this._visitables.get("connectionOverrides").add(this.connectionOverrides);
    } else {
        this.connectionOverrides = null;
        this._visitables.get("connectionOverrides").remove(this.connectionOverrides);
    }
    return (A) this;
  }
  
  public boolean hasConnectionOverrides() {
    return this.connectionOverrides != null;
  }
  
  public A withNewConnectionOverrides(String acceptContentTypes,Integer burst,String contentType,Float qps) {
    return (A)withConnectionOverrides(new ClientConnectionOverrides(acceptContentTypes, burst, contentType, qps));
  }
  
  public ConnectionOverridesNested<A> withNewConnectionOverrides() {
    return new ConnectionOverridesNested(null);
  }
  
  public ConnectionOverridesNested<A> withNewConnectionOverridesLike(ClientConnectionOverrides item) {
    return new ConnectionOverridesNested(item);
  }
  
  public ConnectionOverridesNested<A> editConnectionOverrides() {
    return withNewConnectionOverridesLike(java.util.Optional.ofNullable(buildConnectionOverrides()).orElse(null));
  }
  
  public ConnectionOverridesNested<A> editOrNewConnectionOverrides() {
    return withNewConnectionOverridesLike(java.util.Optional.ofNullable(buildConnectionOverrides()).orElse(new ClientConnectionOverridesBuilder().build()));
  }
  
  public ConnectionOverridesNested<A> editOrNewConnectionOverridesLike(ClientConnectionOverrides item) {
    return withNewConnectionOverridesLike(java.util.Optional.ofNullable(buildConnectionOverrides()).orElse(item));
  }
  
  public String getKubeConfig() {
    return this.kubeConfig;
  }
  
  public A withKubeConfig(String kubeConfig) {
    this.kubeConfig = kubeConfig;
    return (A) this;
  }
  
  public boolean hasKubeConfig() {
    return this.kubeConfig != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubeClientConfigFluent that = (KubeClientConfigFluent) o;
    if (!java.util.Objects.equals(connectionOverrides, that.connectionOverrides)) return false;
    if (!java.util.Objects.equals(kubeConfig, that.kubeConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(connectionOverrides,  kubeConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionOverrides != null) { sb.append("connectionOverrides:"); sb.append(connectionOverrides + ","); }
    if (kubeConfig != null) { sb.append("kubeConfig:"); sb.append(kubeConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConnectionOverridesNested<N> extends ClientConnectionOverridesFluent<ConnectionOverridesNested<N>> implements Nested<N>{
    ConnectionOverridesNested(ClientConnectionOverrides item) {
      this.builder = new ClientConnectionOverridesBuilder(this, item);
    }
    ClientConnectionOverridesBuilder builder;
    
    public N and() {
      return (N) KubeClientConfigFluent.this.withConnectionOverrides(builder.build());
    }
    
    public N endConnectionOverrides() {
      return and();
    }
    
  
  }

}