package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KMSConfigBuilder extends KMSConfigFluent<KMSConfigBuilder> implements VisitableBuilder<KMSConfig,KMSConfigBuilder>{
  public KMSConfigBuilder() {
    this(new KMSConfig());
  }
  
  public KMSConfigBuilder(KMSConfigFluent<?> fluent) {
    this(fluent, new KMSConfig());
  }
  
  public KMSConfigBuilder(KMSConfigFluent<?> fluent,KMSConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KMSConfigBuilder(KMSConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KMSConfigFluent<?> fluent;
  
  public KMSConfig build() {
    KMSConfig buildable = new KMSConfig(fluent.buildAws(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}