package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressPlatformSpecBuilder extends IngressPlatformSpecFluent<IngressPlatformSpecBuilder> implements VisitableBuilder<IngressPlatformSpec,IngressPlatformSpecBuilder>{
  public IngressPlatformSpecBuilder() {
    this(new IngressPlatformSpec());
  }
  
  public IngressPlatformSpecBuilder(IngressPlatformSpecFluent<?> fluent) {
    this(fluent, new IngressPlatformSpec());
  }
  
  public IngressPlatformSpecBuilder(IngressPlatformSpecFluent<?> fluent,IngressPlatformSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressPlatformSpecBuilder(IngressPlatformSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressPlatformSpecFluent<?> fluent;
  
  public IngressPlatformSpec build() {
    IngressPlatformSpec buildable = new IngressPlatformSpec(fluent.buildAws(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}