package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InfrastructureListBuilder extends InfrastructureListFluent<InfrastructureListBuilder> implements VisitableBuilder<InfrastructureList,InfrastructureListBuilder>{
  public InfrastructureListBuilder() {
    this(new InfrastructureList());
  }
  
  public InfrastructureListBuilder(InfrastructureListFluent<?> fluent) {
    this(fluent, new InfrastructureList());
  }
  
  public InfrastructureListBuilder(InfrastructureListFluent<?> fluent,InfrastructureList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InfrastructureListBuilder(InfrastructureList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InfrastructureListFluent<?> fluent;
  
  public InfrastructureList build() {
    InfrastructureList buildable = new InfrastructureList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}