package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageStatusBuilder extends ImageStatusFluent<ImageStatusBuilder> implements VisitableBuilder<ImageStatus,ImageStatusBuilder>{
  public ImageStatusBuilder() {
    this(new ImageStatus());
  }
  
  public ImageStatusBuilder(ImageStatusFluent<?> fluent) {
    this(fluent, new ImageStatus());
  }
  
  public ImageStatusBuilder(ImageStatusFluent<?> fluent,ImageStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageStatusBuilder(ImageStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageStatusFluent<?> fluent;
  
  public ImageStatus build() {
    ImageStatus buildable = new ImageStatus(fluent.getExternalRegistryHostnames(),fluent.getImageStreamImportMode(),fluent.getInternalRegistryHostname());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}