/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.OIDCClientConfig;
import io.fabric8.openshift.api.model.config.v1.OIDCClientConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.OIDCClientConfigFluent;
import io.fabric8.openshift.api.model.config.v1.OIDCProvider;
import io.fabric8.openshift.api.model.config.v1.TokenClaimMappings;
import io.fabric8.openshift.api.model.config.v1.TokenClaimMappingsBuilder;
import io.fabric8.openshift.api.model.config.v1.TokenClaimMappingsFluent;
import io.fabric8.openshift.api.model.config.v1.TokenClaimValidationRule;
import io.fabric8.openshift.api.model.config.v1.TokenClaimValidationRuleBuilder;
import io.fabric8.openshift.api.model.config.v1.TokenClaimValidationRuleFluent;
import io.fabric8.openshift.api.model.config.v1.TokenIssuer;
import io.fabric8.openshift.api.model.config.v1.TokenIssuerBuilder;
import io.fabric8.openshift.api.model.config.v1.TokenIssuerFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OIDCProviderFluent<A extends OIDCProviderFluent<A>>
extends BaseFluent<A> {
    private TokenClaimMappingsBuilder claimMappings;
    private ArrayList<TokenClaimValidationRuleBuilder> claimValidationRules = new ArrayList();
    private TokenIssuerBuilder issuer;
    private String name;
    private ArrayList<OIDCClientConfigBuilder> oidcClients = new ArrayList();
    private Map<String, Object> additionalProperties;

    public OIDCProviderFluent() {
    }

    public OIDCProviderFluent(OIDCProvider instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OIDCProvider instance) {
        OIDCProvider oIDCProvider = instance = instance != null ? instance : new OIDCProvider();
        if (instance != null) {
            this.withClaimMappings(instance.getClaimMappings());
            this.withClaimValidationRules(instance.getClaimValidationRules());
            this.withIssuer(instance.getIssuer());
            this.withName(instance.getName());
            this.withOidcClients(instance.getOidcClients());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TokenClaimMappings buildClaimMappings() {
        return this.claimMappings != null ? this.claimMappings.build() : null;
    }

    public A withClaimMappings(TokenClaimMappings claimMappings) {
        this._visitables.remove((Object)"claimMappings");
        if (claimMappings != null) {
            this.claimMappings = new TokenClaimMappingsBuilder(claimMappings);
            this._visitables.get((Object)"claimMappings").add(this.claimMappings);
        } else {
            this.claimMappings = null;
            this._visitables.get((Object)"claimMappings").remove((Object)this.claimMappings);
        }
        return (A)((Object)this);
    }

    public boolean hasClaimMappings() {
        return this.claimMappings != null;
    }

    public ClaimMappingsNested<A> withNewClaimMappings() {
        return new ClaimMappingsNested(null);
    }

    public ClaimMappingsNested<A> withNewClaimMappingsLike(TokenClaimMappings item) {
        return new ClaimMappingsNested(item);
    }

    public ClaimMappingsNested<A> editClaimMappings() {
        return this.withNewClaimMappingsLike(Optional.ofNullable(this.buildClaimMappings()).orElse(null));
    }

    public ClaimMappingsNested<A> editOrNewClaimMappings() {
        return this.withNewClaimMappingsLike(Optional.ofNullable(this.buildClaimMappings()).orElse(new TokenClaimMappingsBuilder().build()));
    }

    public ClaimMappingsNested<A> editOrNewClaimMappingsLike(TokenClaimMappings item) {
        return this.withNewClaimMappingsLike(Optional.ofNullable(this.buildClaimMappings()).orElse(item));
    }

    public A addToClaimValidationRules(int index, TokenClaimValidationRule item) {
        if (this.claimValidationRules == null) {
            this.claimValidationRules = new ArrayList();
        }
        TokenClaimValidationRuleBuilder builder = new TokenClaimValidationRuleBuilder(item);
        if (index < 0 || index >= this.claimValidationRules.size()) {
            this._visitables.get((Object)"claimValidationRules").add(builder);
            this.claimValidationRules.add(builder);
        } else {
            this._visitables.get((Object)"claimValidationRules").add(index, builder);
            this.claimValidationRules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClaimValidationRules(int index, TokenClaimValidationRule item) {
        if (this.claimValidationRules == null) {
            this.claimValidationRules = new ArrayList();
        }
        TokenClaimValidationRuleBuilder builder = new TokenClaimValidationRuleBuilder(item);
        if (index < 0 || index >= this.claimValidationRules.size()) {
            this._visitables.get((Object)"claimValidationRules").add(builder);
            this.claimValidationRules.add(builder);
        } else {
            this._visitables.get((Object)"claimValidationRules").set(index, builder);
            this.claimValidationRules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClaimValidationRules(TokenClaimValidationRule ... items) {
        if (this.claimValidationRules == null) {
            this.claimValidationRules = new ArrayList();
        }
        for (TokenClaimValidationRule item : items) {
            TokenClaimValidationRuleBuilder builder = new TokenClaimValidationRuleBuilder(item);
            this._visitables.get((Object)"claimValidationRules").add(builder);
            this.claimValidationRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClaimValidationRules(Collection<TokenClaimValidationRule> items) {
        if (this.claimValidationRules == null) {
            this.claimValidationRules = new ArrayList();
        }
        for (TokenClaimValidationRule item : items) {
            TokenClaimValidationRuleBuilder builder = new TokenClaimValidationRuleBuilder(item);
            this._visitables.get((Object)"claimValidationRules").add(builder);
            this.claimValidationRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClaimValidationRules(TokenClaimValidationRule ... items) {
        if (this.claimValidationRules == null) {
            return (A)((Object)this);
        }
        for (TokenClaimValidationRule item : items) {
            TokenClaimValidationRuleBuilder builder = new TokenClaimValidationRuleBuilder(item);
            this._visitables.get((Object)"claimValidationRules").remove((Object)builder);
            this.claimValidationRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClaimValidationRules(Collection<TokenClaimValidationRule> items) {
        if (this.claimValidationRules == null) {
            return (A)((Object)this);
        }
        for (TokenClaimValidationRule item : items) {
            TokenClaimValidationRuleBuilder builder = new TokenClaimValidationRuleBuilder(item);
            this._visitables.get((Object)"claimValidationRules").remove((Object)builder);
            this.claimValidationRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClaimValidationRules(Predicate<TokenClaimValidationRuleBuilder> predicate) {
        if (this.claimValidationRules == null) {
            return (A)((Object)this);
        }
        Iterator<TokenClaimValidationRuleBuilder> each = this.claimValidationRules.iterator();
        List visitables = this._visitables.get((Object)"claimValidationRules");
        while (each.hasNext()) {
            TokenClaimValidationRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TokenClaimValidationRule> buildClaimValidationRules() {
        return this.claimValidationRules != null ? OIDCProviderFluent.build(this.claimValidationRules) : null;
    }

    public TokenClaimValidationRule buildClaimValidationRule(int index) {
        return this.claimValidationRules.get(index).build();
    }

    public TokenClaimValidationRule buildFirstClaimValidationRule() {
        return this.claimValidationRules.get(0).build();
    }

    public TokenClaimValidationRule buildLastClaimValidationRule() {
        return this.claimValidationRules.get(this.claimValidationRules.size() - 1).build();
    }

    public TokenClaimValidationRule buildMatchingClaimValidationRule(Predicate<TokenClaimValidationRuleBuilder> predicate) {
        for (TokenClaimValidationRuleBuilder item : this.claimValidationRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClaimValidationRule(Predicate<TokenClaimValidationRuleBuilder> predicate) {
        for (TokenClaimValidationRuleBuilder item : this.claimValidationRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClaimValidationRules(List<TokenClaimValidationRule> claimValidationRules) {
        if (this.claimValidationRules != null) {
            this._visitables.get((Object)"claimValidationRules").clear();
        }
        if (claimValidationRules != null) {
            this.claimValidationRules = new ArrayList();
            for (TokenClaimValidationRule item : claimValidationRules) {
                this.addToClaimValidationRules(item);
            }
        } else {
            this.claimValidationRules = null;
        }
        return (A)((Object)this);
    }

    public A withClaimValidationRules(TokenClaimValidationRule ... claimValidationRules) {
        if (this.claimValidationRules != null) {
            this.claimValidationRules.clear();
            this._visitables.remove((Object)"claimValidationRules");
        }
        if (claimValidationRules != null) {
            for (TokenClaimValidationRule item : claimValidationRules) {
                this.addToClaimValidationRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClaimValidationRules() {
        return this.claimValidationRules != null && !this.claimValidationRules.isEmpty();
    }

    public ClaimValidationRulesNested<A> addNewClaimValidationRule() {
        return new ClaimValidationRulesNested(-1, null);
    }

    public ClaimValidationRulesNested<A> addNewClaimValidationRuleLike(TokenClaimValidationRule item) {
        return new ClaimValidationRulesNested(-1, item);
    }

    public ClaimValidationRulesNested<A> setNewClaimValidationRuleLike(int index, TokenClaimValidationRule item) {
        return new ClaimValidationRulesNested(index, item);
    }

    public ClaimValidationRulesNested<A> editClaimValidationRule(int index) {
        if (this.claimValidationRules.size() <= index) {
            throw new RuntimeException("Can't edit claimValidationRules. Index exceeds size.");
        }
        return this.setNewClaimValidationRuleLike(index, this.buildClaimValidationRule(index));
    }

    public ClaimValidationRulesNested<A> editFirstClaimValidationRule() {
        if (this.claimValidationRules.size() == 0) {
            throw new RuntimeException("Can't edit first claimValidationRules. The list is empty.");
        }
        return this.setNewClaimValidationRuleLike(0, this.buildClaimValidationRule(0));
    }

    public ClaimValidationRulesNested<A> editLastClaimValidationRule() {
        int index = this.claimValidationRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last claimValidationRules. The list is empty.");
        }
        return this.setNewClaimValidationRuleLike(index, this.buildClaimValidationRule(index));
    }

    public ClaimValidationRulesNested<A> editMatchingClaimValidationRule(Predicate<TokenClaimValidationRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.claimValidationRules.size(); ++i) {
            if (!predicate.test(this.claimValidationRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching claimValidationRules. No match found.");
        }
        return this.setNewClaimValidationRuleLike(index, this.buildClaimValidationRule(index));
    }

    public TokenIssuer buildIssuer() {
        return this.issuer != null ? this.issuer.build() : null;
    }

    public A withIssuer(TokenIssuer issuer) {
        this._visitables.remove((Object)"issuer");
        if (issuer != null) {
            this.issuer = new TokenIssuerBuilder(issuer);
            this._visitables.get((Object)"issuer").add(this.issuer);
        } else {
            this.issuer = null;
            this._visitables.get((Object)"issuer").remove((Object)this.issuer);
        }
        return (A)((Object)this);
    }

    public boolean hasIssuer() {
        return this.issuer != null;
    }

    public IssuerNested<A> withNewIssuer() {
        return new IssuerNested(null);
    }

    public IssuerNested<A> withNewIssuerLike(TokenIssuer item) {
        return new IssuerNested(item);
    }

    public IssuerNested<A> editIssuer() {
        return this.withNewIssuerLike(Optional.ofNullable(this.buildIssuer()).orElse(null));
    }

    public IssuerNested<A> editOrNewIssuer() {
        return this.withNewIssuerLike(Optional.ofNullable(this.buildIssuer()).orElse(new TokenIssuerBuilder().build()));
    }

    public IssuerNested<A> editOrNewIssuerLike(TokenIssuer item) {
        return this.withNewIssuerLike(Optional.ofNullable(this.buildIssuer()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToOidcClients(int index, OIDCClientConfig item) {
        if (this.oidcClients == null) {
            this.oidcClients = new ArrayList();
        }
        OIDCClientConfigBuilder builder = new OIDCClientConfigBuilder(item);
        if (index < 0 || index >= this.oidcClients.size()) {
            this._visitables.get((Object)"oidcClients").add(builder);
            this.oidcClients.add(builder);
        } else {
            this._visitables.get((Object)"oidcClients").add(index, builder);
            this.oidcClients.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOidcClients(int index, OIDCClientConfig item) {
        if (this.oidcClients == null) {
            this.oidcClients = new ArrayList();
        }
        OIDCClientConfigBuilder builder = new OIDCClientConfigBuilder(item);
        if (index < 0 || index >= this.oidcClients.size()) {
            this._visitables.get((Object)"oidcClients").add(builder);
            this.oidcClients.add(builder);
        } else {
            this._visitables.get((Object)"oidcClients").set(index, builder);
            this.oidcClients.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOidcClients(OIDCClientConfig ... items) {
        if (this.oidcClients == null) {
            this.oidcClients = new ArrayList();
        }
        for (OIDCClientConfig item : items) {
            OIDCClientConfigBuilder builder = new OIDCClientConfigBuilder(item);
            this._visitables.get((Object)"oidcClients").add(builder);
            this.oidcClients.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOidcClients(Collection<OIDCClientConfig> items) {
        if (this.oidcClients == null) {
            this.oidcClients = new ArrayList();
        }
        for (OIDCClientConfig item : items) {
            OIDCClientConfigBuilder builder = new OIDCClientConfigBuilder(item);
            this._visitables.get((Object)"oidcClients").add(builder);
            this.oidcClients.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOidcClients(OIDCClientConfig ... items) {
        if (this.oidcClients == null) {
            return (A)((Object)this);
        }
        for (OIDCClientConfig item : items) {
            OIDCClientConfigBuilder builder = new OIDCClientConfigBuilder(item);
            this._visitables.get((Object)"oidcClients").remove((Object)builder);
            this.oidcClients.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOidcClients(Collection<OIDCClientConfig> items) {
        if (this.oidcClients == null) {
            return (A)((Object)this);
        }
        for (OIDCClientConfig item : items) {
            OIDCClientConfigBuilder builder = new OIDCClientConfigBuilder(item);
            this._visitables.get((Object)"oidcClients").remove((Object)builder);
            this.oidcClients.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOidcClients(Predicate<OIDCClientConfigBuilder> predicate) {
        if (this.oidcClients == null) {
            return (A)((Object)this);
        }
        Iterator<OIDCClientConfigBuilder> each = this.oidcClients.iterator();
        List visitables = this._visitables.get((Object)"oidcClients");
        while (each.hasNext()) {
            OIDCClientConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<OIDCClientConfig> buildOidcClients() {
        return this.oidcClients != null ? OIDCProviderFluent.build(this.oidcClients) : null;
    }

    public OIDCClientConfig buildOidcClient(int index) {
        return this.oidcClients.get(index).build();
    }

    public OIDCClientConfig buildFirstOidcClient() {
        return this.oidcClients.get(0).build();
    }

    public OIDCClientConfig buildLastOidcClient() {
        return this.oidcClients.get(this.oidcClients.size() - 1).build();
    }

    public OIDCClientConfig buildMatchingOidcClient(Predicate<OIDCClientConfigBuilder> predicate) {
        for (OIDCClientConfigBuilder item : this.oidcClients) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOidcClient(Predicate<OIDCClientConfigBuilder> predicate) {
        for (OIDCClientConfigBuilder item : this.oidcClients) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOidcClients(List<OIDCClientConfig> oidcClients) {
        if (this.oidcClients != null) {
            this._visitables.get((Object)"oidcClients").clear();
        }
        if (oidcClients != null) {
            this.oidcClients = new ArrayList();
            for (OIDCClientConfig item : oidcClients) {
                this.addToOidcClients(item);
            }
        } else {
            this.oidcClients = null;
        }
        return (A)((Object)this);
    }

    public A withOidcClients(OIDCClientConfig ... oidcClients) {
        if (this.oidcClients != null) {
            this.oidcClients.clear();
            this._visitables.remove((Object)"oidcClients");
        }
        if (oidcClients != null) {
            for (OIDCClientConfig item : oidcClients) {
                this.addToOidcClients(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOidcClients() {
        return this.oidcClients != null && !this.oidcClients.isEmpty();
    }

    public OidcClientsNested<A> addNewOidcClient() {
        return new OidcClientsNested(-1, null);
    }

    public OidcClientsNested<A> addNewOidcClientLike(OIDCClientConfig item) {
        return new OidcClientsNested(-1, item);
    }

    public OidcClientsNested<A> setNewOidcClientLike(int index, OIDCClientConfig item) {
        return new OidcClientsNested(index, item);
    }

    public OidcClientsNested<A> editOidcClient(int index) {
        if (this.oidcClients.size() <= index) {
            throw new RuntimeException("Can't edit oidcClients. Index exceeds size.");
        }
        return this.setNewOidcClientLike(index, this.buildOidcClient(index));
    }

    public OidcClientsNested<A> editFirstOidcClient() {
        if (this.oidcClients.size() == 0) {
            throw new RuntimeException("Can't edit first oidcClients. The list is empty.");
        }
        return this.setNewOidcClientLike(0, this.buildOidcClient(0));
    }

    public OidcClientsNested<A> editLastOidcClient() {
        int index = this.oidcClients.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last oidcClients. The list is empty.");
        }
        return this.setNewOidcClientLike(index, this.buildOidcClient(index));
    }

    public OidcClientsNested<A> editMatchingOidcClient(Predicate<OIDCClientConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.oidcClients.size(); ++i) {
            if (!predicate.test(this.oidcClients.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching oidcClients. No match found.");
        }
        return this.setNewOidcClientLike(index, this.buildOidcClient(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OIDCProviderFluent that = (OIDCProviderFluent)((Object)o);
        if (!Objects.equals((Object)this.claimMappings, (Object)that.claimMappings)) {
            return false;
        }
        if (!Objects.equals(this.claimValidationRules, that.claimValidationRules)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuer, (Object)that.issuer)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.oidcClients, that.oidcClients)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.claimMappings, this.claimValidationRules, this.issuer, this.name, this.oidcClients, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claimMappings != null) {
            sb.append("claimMappings:");
            sb.append(this.claimMappings + ",");
        }
        if (this.claimValidationRules != null && !this.claimValidationRules.isEmpty()) {
            sb.append("claimValidationRules:");
            sb.append(this.claimValidationRules + ",");
        }
        if (this.issuer != null) {
            sb.append("issuer:");
            sb.append(this.issuer + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.oidcClients != null && !this.oidcClients.isEmpty()) {
            sb.append("oidcClients:");
            sb.append(this.oidcClients + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OidcClientsNested<N>
    extends OIDCClientConfigFluent<OidcClientsNested<N>>
    implements Nested<N> {
        OIDCClientConfigBuilder builder;
        int index;

        OidcClientsNested(int index, OIDCClientConfig item) {
            this.index = index;
            this.builder = new OIDCClientConfigBuilder(this, item);
        }

        public N and() {
            return (N)OIDCProviderFluent.this.setToOidcClients(this.index, this.builder.build());
        }

        public N endOidcClient() {
            return this.and();
        }
    }

    public class IssuerNested<N>
    extends TokenIssuerFluent<IssuerNested<N>>
    implements Nested<N> {
        TokenIssuerBuilder builder;

        IssuerNested(TokenIssuer item) {
            this.builder = new TokenIssuerBuilder(this, item);
        }

        public N and() {
            return (N)OIDCProviderFluent.this.withIssuer(this.builder.build());
        }

        public N endIssuer() {
            return this.and();
        }
    }

    public class ClaimValidationRulesNested<N>
    extends TokenClaimValidationRuleFluent<ClaimValidationRulesNested<N>>
    implements Nested<N> {
        TokenClaimValidationRuleBuilder builder;
        int index;

        ClaimValidationRulesNested(int index, TokenClaimValidationRule item) {
            this.index = index;
            this.builder = new TokenClaimValidationRuleBuilder(this, item);
        }

        public N and() {
            return (N)OIDCProviderFluent.this.setToClaimValidationRules(this.index, this.builder.build());
        }

        public N endClaimValidationRule() {
            return this.and();
        }
    }

    public class ClaimMappingsNested<N>
    extends TokenClaimMappingsFluent<ClaimMappingsNested<N>>
    implements Nested<N> {
        TokenClaimMappingsBuilder builder;

        ClaimMappingsNested(TokenClaimMappings item) {
            this.builder = new TokenClaimMappingsBuilder(this, item);
        }

        public N and() {
            return (N)OIDCProviderFluent.this.withClaimMappings(this.builder.build());
        }

        public N endClaimMappings() {
            return this.and();
        }
    }
}

