/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.InfrastructureStatus;
import io.fabric8.openshift.api.model.config.v1.InfrastructureStatusFluent;
import io.fabric8.openshift.api.model.config.v1.PlatformStatus;
import io.fabric8.openshift.api.model.config.v1.PlatformStatusBuilder;
import io.fabric8.openshift.api.model.config.v1.PlatformStatusFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class InfrastructureStatusFluentImpl<A extends InfrastructureStatusFluent<A>>
extends BaseFluent<A>
implements InfrastructureStatusFluent<A> {
    private String apiServerInternalURI;
    private String apiServerURL;
    private String controlPlaneTopology;
    private String etcdDiscoveryDomain;
    private String infrastructureName;
    private String infrastructureTopology;
    private String platform;
    private PlatformStatusBuilder platformStatus;
    private Map<String, Object> additionalProperties;

    public InfrastructureStatusFluentImpl() {
    }

    public InfrastructureStatusFluentImpl(InfrastructureStatus instance) {
        this.withApiServerInternalURI(instance.getApiServerInternalURI());
        this.withApiServerURL(instance.getApiServerURL());
        this.withControlPlaneTopology(instance.getControlPlaneTopology());
        this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
        this.withInfrastructureName(instance.getInfrastructureName());
        this.withInfrastructureTopology(instance.getInfrastructureTopology());
        this.withPlatform(instance.getPlatform());
        this.withPlatformStatus(instance.getPlatformStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiServerInternalURI() {
        return this.apiServerInternalURI;
    }

    @Override
    public A withApiServerInternalURI(String apiServerInternalURI) {
        this.apiServerInternalURI = apiServerInternalURI;
        return (A)this;
    }

    @Override
    public Boolean hasApiServerInternalURI() {
        return this.apiServerInternalURI != null;
    }

    @Override
    public String getApiServerURL() {
        return this.apiServerURL;
    }

    @Override
    public A withApiServerURL(String apiServerURL) {
        this.apiServerURL = apiServerURL;
        return (A)this;
    }

    @Override
    public Boolean hasApiServerURL() {
        return this.apiServerURL != null;
    }

    @Override
    public String getControlPlaneTopology() {
        return this.controlPlaneTopology;
    }

    @Override
    public A withControlPlaneTopology(String controlPlaneTopology) {
        this.controlPlaneTopology = controlPlaneTopology;
        return (A)this;
    }

    @Override
    public Boolean hasControlPlaneTopology() {
        return this.controlPlaneTopology != null;
    }

    @Override
    public String getEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain;
    }

    @Override
    public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain) {
        this.etcdDiscoveryDomain = etcdDiscoveryDomain;
        return (A)this;
    }

    @Override
    public Boolean hasEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain != null;
    }

    @Override
    public String getInfrastructureName() {
        return this.infrastructureName;
    }

    @Override
    public A withInfrastructureName(String infrastructureName) {
        this.infrastructureName = infrastructureName;
        return (A)this;
    }

    @Override
    public Boolean hasInfrastructureName() {
        return this.infrastructureName != null;
    }

    @Override
    public String getInfrastructureTopology() {
        return this.infrastructureTopology;
    }

    @Override
    public A withInfrastructureTopology(String infrastructureTopology) {
        this.infrastructureTopology = infrastructureTopology;
        return (A)this;
    }

    @Override
    public Boolean hasInfrastructureTopology() {
        return this.infrastructureTopology != null;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    @Deprecated
    public PlatformStatus getPlatformStatus() {
        return this.platformStatus != null ? this.platformStatus.build() : null;
    }

    @Override
    public PlatformStatus buildPlatformStatus() {
        return this.platformStatus != null ? this.platformStatus.build() : null;
    }

    @Override
    public A withPlatformStatus(PlatformStatus platformStatus) {
        this._visitables.get((Object)"platformStatus").remove(this.platformStatus);
        if (platformStatus != null) {
            this.platformStatus = new PlatformStatusBuilder(platformStatus);
            this._visitables.get((Object)"platformStatus").add(this.platformStatus);
        } else {
            this.platformStatus = null;
            this._visitables.get((Object)"platformStatus").remove(this.platformStatus);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatformStatus() {
        return this.platformStatus != null;
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatus() {
        return new PlatformStatusNestedImpl();
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item) {
        return new PlatformStatusNestedImpl(item);
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editPlatformStatus() {
        return this.withNewPlatformStatusLike(this.getPlatformStatus());
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatus() {
        return this.withNewPlatformStatusLike(this.getPlatformStatus() != null ? this.getPlatformStatus() : new PlatformStatusBuilder().build());
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item) {
        return this.withNewPlatformStatusLike(this.getPlatformStatus() != null ? this.getPlatformStatus() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfrastructureStatusFluentImpl that = (InfrastructureStatusFluentImpl)o;
        if (this.apiServerInternalURI != null ? !this.apiServerInternalURI.equals(that.apiServerInternalURI) : that.apiServerInternalURI != null) {
            return false;
        }
        if (this.apiServerURL != null ? !this.apiServerURL.equals(that.apiServerURL) : that.apiServerURL != null) {
            return false;
        }
        if (this.controlPlaneTopology != null ? !this.controlPlaneTopology.equals(that.controlPlaneTopology) : that.controlPlaneTopology != null) {
            return false;
        }
        if (this.etcdDiscoveryDomain != null ? !this.etcdDiscoveryDomain.equals(that.etcdDiscoveryDomain) : that.etcdDiscoveryDomain != null) {
            return false;
        }
        if (this.infrastructureName != null ? !this.infrastructureName.equals(that.infrastructureName) : that.infrastructureName != null) {
            return false;
        }
        if (this.infrastructureTopology != null ? !this.infrastructureTopology.equals(that.infrastructureTopology) : that.infrastructureTopology != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        if (this.platformStatus != null ? !this.platformStatus.equals(that.platformStatus) : that.platformStatus != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiServerInternalURI, this.apiServerURL, this.controlPlaneTopology, this.etcdDiscoveryDomain, this.infrastructureName, this.infrastructureTopology, this.platform, this.platformStatus, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerInternalURI != null) {
            sb.append("apiServerInternalURI:");
            sb.append(this.apiServerInternalURI + ",");
        }
        if (this.apiServerURL != null) {
            sb.append("apiServerURL:");
            sb.append(this.apiServerURL + ",");
        }
        if (this.controlPlaneTopology != null) {
            sb.append("controlPlaneTopology:");
            sb.append(this.controlPlaneTopology + ",");
        }
        if (this.etcdDiscoveryDomain != null) {
            sb.append("etcdDiscoveryDomain:");
            sb.append(this.etcdDiscoveryDomain + ",");
        }
        if (this.infrastructureName != null) {
            sb.append("infrastructureName:");
            sb.append(this.infrastructureName + ",");
        }
        if (this.infrastructureTopology != null) {
            sb.append("infrastructureTopology:");
            sb.append(this.infrastructureTopology + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.platformStatus != null) {
            sb.append("platformStatus:");
            sb.append(this.platformStatus + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PlatformStatusNestedImpl<N>
    extends PlatformStatusFluentImpl<InfrastructureStatusFluent.PlatformStatusNested<N>>
    implements InfrastructureStatusFluent.PlatformStatusNested<N>,
    Nested<N> {
        PlatformStatusBuilder builder;

        PlatformStatusNestedImpl(PlatformStatus item) {
            this.builder = new PlatformStatusBuilder(this, item);
        }

        PlatformStatusNestedImpl() {
            this.builder = new PlatformStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)InfrastructureStatusFluentImpl.this.withPlatformStatus(this.builder.build());
        }

        @Override
        public N endPlatformStatus() {
            return this.and();
        }
    }
}

