package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ComponentRouteSpecBuilder extends ComponentRouteSpecFluent<ComponentRouteSpecBuilder> implements VisitableBuilder<ComponentRouteSpec,ComponentRouteSpecBuilder>{
  public ComponentRouteSpecBuilder() {
    this(new ComponentRouteSpec());
  }
  
  public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent) {
    this(fluent, new ComponentRouteSpec());
  }
  
  public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent,ComponentRouteSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ComponentRouteSpecBuilder(ComponentRouteSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ComponentRouteSpecFluent<?> fluent;
  
  public ComponentRouteSpec build() {
    ComponentRouteSpec buildable = new ComponentRouteSpec(fluent.getHostname(),fluent.getName(),fluent.getNamespace(),fluent.buildServingCertKeyPairSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}