/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.autoscaling.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.autoscaling.v1beta1.MachineAutoscalerSpec;
import io.fabric8.openshift.api.model.autoscaling.v1beta1.MachineAutoscalerSpecScaleTargetRef;
import io.fabric8.openshift.api.model.autoscaling.v1beta1.MachineAutoscalerSpecScaleTargetRefBuilder;
import io.fabric8.openshift.api.model.autoscaling.v1beta1.MachineAutoscalerSpecScaleTargetRefFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineAutoscalerSpecFluent<A extends MachineAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private Integer maxReplicas;
    private Integer minReplicas;
    private MachineAutoscalerSpecScaleTargetRefBuilder scaleTargetRef;
    private Map<String, Object> additionalProperties;

    public MachineAutoscalerSpecFluent() {
    }

    public MachineAutoscalerSpecFluent(MachineAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineAutoscalerSpec instance) {
        MachineAutoscalerSpec machineAutoscalerSpec = instance = instance != null ? instance : new MachineAutoscalerSpec();
        if (instance != null) {
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)((Object)this);
    }

    public boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)((Object)this);
    }

    public boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    public MachineAutoscalerSpecScaleTargetRef buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    public A withScaleTargetRef(MachineAutoscalerSpecScaleTargetRef scaleTargetRef) {
        this._visitables.remove((Object)"scaleTargetRef");
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new MachineAutoscalerSpecScaleTargetRefBuilder(scaleTargetRef);
            this._visitables.get((Object)"scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get((Object)"scaleTargetRef").remove((Object)this.scaleTargetRef);
        }
        return (A)((Object)this);
    }

    public boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public A withNewScaleTargetRef(String apiVersion, String kind, String name) {
        return this.withScaleTargetRef(new MachineAutoscalerSpecScaleTargetRef(apiVersion, kind, name));
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNested(null);
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRefLike(MachineAutoscalerSpecScaleTargetRef item) {
        return new ScaleTargetRefNested(item);
    }

    public ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(null));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(new MachineAutoscalerSpecScaleTargetRefBuilder().build()));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(MachineAutoscalerSpecScaleTargetRef item) {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineAutoscalerSpecFluent that = (MachineAutoscalerSpecFluent)((Object)o);
        if (!Objects.equals(this.maxReplicas, that.maxReplicas)) {
            return false;
        }
        if (!Objects.equals(this.minReplicas, that.minReplicas)) {
            return false;
        }
        if (!Objects.equals((Object)this.scaleTargetRef, (Object)that.scaleTargetRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxReplicas, this.minReplicas, this.scaleTargetRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(String.valueOf((Object)this.scaleTargetRef) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScaleTargetRefNested<N>
    extends MachineAutoscalerSpecScaleTargetRefFluent<ScaleTargetRefNested<N>>
    implements Nested<N> {
        MachineAutoscalerSpecScaleTargetRefBuilder builder;

        ScaleTargetRefNested(MachineAutoscalerSpecScaleTargetRef item) {
            this.builder = new MachineAutoscalerSpecScaleTargetRefBuilder(this, item);
        }

        public N and() {
            return (N)MachineAutoscalerSpecFluent.this.withScaleTargetRef(this.builder.build());
        }

        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

