/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.build;

import com.fasterxml.jackson.core.type.TypeReference;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.TimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.AsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.AuthorEmailable;
import io.fabric8.openshift.client.dsl.buildconfig.AuthorMessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.CommitterAuthorMessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.CommitterEmailable;
import io.fabric8.openshift.client.dsl.buildconfig.MessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.internal.BuildConfigOperationContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfigOperationsImpl
extends HasMetadataOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>>
implements BuildConfigResource<BuildConfig, Void, Build>,
CommitterAuthorMessageAsFileTimeoutInputStreamable<Build> {
    private static final Logger logger = LoggerFactory.getLogger(BuildConfigOperationsImpl.class);
    private final BuildConfigOperationContext buildConfigOperationContext;
    private final String secret;
    private final String triggerType;
    private final String authorName;
    private final String authorEmail;
    private final String committerName;
    private final String committerEmail;
    private final String commit;
    private final String message;
    private final String asFile;

    public BuildConfigOperationsImpl(Client client) {
        this(new BuildConfigOperationContext(), HasMetadataOperationsImpl.defaultContext((Client)client).withRequestConfig(((RequestConfigBuilder)new RequestConfigBuilder(client.getConfiguration().getRequestConfig()).withRequestTimeout(0)).build()));
    }

    public BuildConfigOperationsImpl(BuildConfigOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("build.openshift.io").withPlural("buildconfigs"), BuildConfig.class, BuildConfigList.class);
        this.buildConfigOperationContext = context;
        this.triggerType = context.getTriggerType();
        this.secret = context.getSecret();
        this.authorName = context.getAuthorName();
        this.authorEmail = context.getAuthorEmail();
        this.committerName = context.getCommitterName();
        this.committerEmail = context.getCommitterEmail();
        this.commit = context.getCommit();
        this.message = context.getMessage();
        this.asFile = context.getAsFile();
    }

    public BuildConfigOperationsImpl newInstance(OperationContext context) {
        return new BuildConfigOperationsImpl(this.buildConfigOperationContext, context);
    }

    public BuildConfigOperationContext getContext() {
        return this.buildConfigOperationContext;
    }

    public Build instantiate(BuildRequest request) {
        try {
            this.updateApiVersion((HasMetadata)request);
            URL instantiationUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiate"}));
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", OperationSupport.JSON_MAPPER.writer().writeValueAsString((Object)request)).url(instantiationUrl);
            return (Build)this.handleResponse(requestBuilder, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public CommitterAuthorMessageAsFileTimeoutInputStreamable<Build> instantiateBinary() {
        return this;
    }

    public Void trigger(WebHookTrigger trigger) {
        try {
            String triggerUrl = URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "webhooks", this.secret, this.triggerType});
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", OperationSupport.JSON_MAPPER.writer().writeValueAsBytes((Object)trigger)).uri(triggerUrl).header("X-Github-Event", "push");
            this.handleResponse(requestBuilder, null);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Triggerable<WebHookTrigger, Void> withType(String triggerType) {
        return new BuildConfigOperationsImpl(this.getContext().withTriggerType(triggerType), this.context);
    }

    public Build fromInputStream(InputStream inputStream) {
        return this.submitToApiServer(inputStream, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Build fromFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Can't instantiate binary build from the specified file. The file does not exists");
        }
        try (FileInputStream is = new FileInputStream(file);){
            logger.debug("Uploading archive file \"{}\" as binary input for the build ...", (Object)file.getAbsolutePath());
            Build build = this.submitToApiServer(is, file.length());
            return build;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private String getQueryParameters() throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiatebinary"}));
        if (Utils.isNotNullOrEmpty((String)this.name)) {
            sb.append("?name=").append(this.name);
        }
        if (Utils.isNotNullOrEmpty((String)this.namespace)) {
            sb.append("&namespace=").append(this.namespace);
        }
        if (Utils.isNotNullOrEmpty((String)this.message)) {
            sb.append("&commit=").append(this.message);
        }
        if (!Utils.isNullOrEmpty((String)this.authorName)) {
            sb.append("&revision.authorName=").append(this.authorName);
        }
        if (!Utils.isNullOrEmpty((String)this.authorEmail)) {
            sb.append("&revision.authorEmail=").append(this.authorEmail);
        }
        if (!Utils.isNullOrEmpty((String)this.committerName)) {
            sb.append("&revision.committerName=").append(this.committerName);
        }
        if (!Utils.isNullOrEmpty((String)this.committerEmail)) {
            sb.append("&revision.committerEmail=").append(this.committerEmail);
        }
        if (!Utils.isNullOrEmpty((String)this.commit)) {
            sb.append("&revision.commit=").append(this.commit);
        }
        if (!Utils.isNullOrEmpty((String)this.asFile)) {
            sb.append("&asFile=").append(this.asFile);
        }
        return sb.toString();
    }

    public TimeoutInputStreamable<Build> asFile(String fileName) {
        return new BuildConfigOperationsImpl(this.getContext().withAsFile(fileName), this.context);
    }

    public MessageAsFileTimeoutInputStreamable<Build> withAuthorEmail(String email) {
        return new BuildConfigOperationsImpl(this.getContext().withAuthorEmail(email), this.context);
    }

    public AuthorMessageAsFileTimeoutInputStreamable<Build> withCommitterEmail(String committerEmail) {
        return new BuildConfigOperationsImpl(this.getContext().withCommitterEmail(committerEmail), this.context);
    }

    public AsFileTimeoutInputStreamable<Build> withMessage(String message) {
        return new BuildConfigOperationsImpl(this.getContext().withMessage(message), this.context);
    }

    public AuthorEmailable<MessageAsFileTimeoutInputStreamable<Build>> withAuthorName(String authorName) {
        return new BuildConfigOperationsImpl(this.getContext().withAuthorName(authorName), this.context);
    }

    public CommitterEmailable<AuthorMessageAsFileTimeoutInputStreamable<Build>> withCommitterName(String committerName) {
        return new BuildConfigOperationsImpl(this.getContext().withCommitterName(committerName), this.context);
    }

    public BuildConfigOperationsImpl withTimeout(long timeout, TimeUnit unit) {
        return new BuildConfigOperationsImpl(this.getContext(), this.context.withTimeout(timeout, unit).withRequestConfig(((RequestConfigBuilder)new RequestConfigBuilder(this.context.getRequestConfig()).withRequestTimeout((int)unit.toMillis(timeout))).build()));
    }

    public BuildConfigOperationsImpl withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl(this.getContext().withSecret(secret), this.context);
    }

    protected Build submitToApiServer(InputStream inputStream, long contentLength) {
        try {
            HttpClient newClient = this.httpClient.newBuilder().tag((Object)this.getOperationContext().getRequestConfig()).readTimeout(this.getOperationContext().getTimeout(), this.getOperationContext().getTimeoutUnit()).writeTimeout(this.getOperationContext().getTimeout(), this.getOperationContext().getTimeoutUnit()).build();
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/octet-stream", inputStream, contentLength).expectContinue().uri(this.getQueryParameters());
            return (Build)this.waitForResult(this.handleResponse(newClient, requestBuilder, (TypeReference)new TypeReference<Build>(){

                public Type getType() {
                    return Build.class;
                }
            }));
        }
        catch (Exception e) {
            logger.error("Failed to upload archive file for the build: {}", (Object)this.name);
            logger.error("Please check cluster events via `oc get events` to see what could have possibly gone wrong");
            throw new KubernetesClientException("Can't instantiate binary build, due to error reading/writing stream. Can be caused if the output stream was closed by the server.See if something's wrong in recent events in Cluster = " + this.getRecentEvents(), (Throwable)e);
        }
    }

    protected String getRecentEvents() {
        StringBuilder eventsAsStrBuilder = new StringBuilder();
        List recentEventList = ((EventList)((NonNamespaceOperation)this.context.getClient().resources(Event.class, EventList.class).inNamespace(this.namespace)).list()).getItems();
        KubernetesResourceUtil.sortEventListBasedOnTimestamp((List)recentEventList);
        for (int i = 0; i < 10 && i < recentEventList.size(); ++i) {
            Event event = (Event)recentEventList.get(i);
            eventsAsStrBuilder.append(event.getReason()).append(" ").append(event.getMetadata().getName()).append(" ").append(event.getMessage()).append("\n");
        }
        return eventsAsStrBuilder.toString();
    }
}

