/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.machine;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSet;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.machine.MachineSetOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class MachineSetHandler
implements ResourceHandler<MachineSet, MachineSetBuilder> {
    public String getKind() {
        return MachineSet.class.getSimpleName();
    }

    public String getApiVersion() {
        return "machine.openshift.io/v1beta1";
    }

    public MachineSet create(OkHttpClient client, Config config, String namespace, MachineSet item, boolean dryRun) {
        return (MachineSet)((WritableOperation)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new MachineSet[0]);
    }

    public MachineSet replace(OkHttpClient client, Config config, String namespace, MachineSet item, boolean dryRun) {
        return (MachineSet)((WritableOperation)((Resource)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public MachineSet reload(OkHttpClient client, Config config, String namespace, MachineSet item) {
        return (MachineSet)((Gettable)((Resource)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public MachineSetBuilder edit(MachineSet item) {
        return new MachineSetBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, MachineSet item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineSet item, Watcher<MachineSet> watcher) {
        return ((Resource)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineSet item, String resourceVersion, Watcher<MachineSet> watcher) {
        return ((Resource)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, MachineSet item, ListOptions options, Watcher<MachineSet> watcher) {
        return ((Resource)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public MachineSet waitUntilReady(OkHttpClient client, Config config, String namespace, MachineSet item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (MachineSet)((Resource)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public MachineSet waitUntilCondition(OkHttpClient client, Config config, String namespace, MachineSet item, Predicate<MachineSet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (MachineSet)((Resource)new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

