/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.ClusterOperator;
import io.fabric8.openshift.api.model.ClusterOperatorBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ClusterOperatorOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterOperatorHandler
implements ResourceHandler<ClusterOperator, ClusterOperatorBuilder> {
    public String getKind() {
        return ClusterOperator.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    public ClusterOperator create(OkHttpClient client, Config config, String namespace, ClusterOperator item, boolean dryRun) {
        return (ClusterOperator)((WritableOperation)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new ClusterOperator[0]);
    }

    public ClusterOperator replace(OkHttpClient client, Config config, String namespace, ClusterOperator item, boolean dryRun) {
        return (ClusterOperator)((WritableOperation)((Resource)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public ClusterOperator reload(OkHttpClient client, Config config, String namespace, ClusterOperator item) {
        return (ClusterOperator)((Gettable)((Resource)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ClusterOperatorBuilder edit(ClusterOperator item) {
        return new ClusterOperatorBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ClusterOperator item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterOperator item, Watcher<ClusterOperator> watcher) {
        return ((Resource)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterOperator item, String resourceVersion, Watcher<ClusterOperator> watcher) {
        return ((Resource)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterOperator item, ListOptions options, Watcher<ClusterOperator> watcher) {
        return ((Resource)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ClusterOperator waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterOperator item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterOperator)((Resource)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ClusterOperator waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterOperator item, Predicate<ClusterOperator> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterOperator)((Resource)new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

