/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    public OpenShiftOperation(OperationContext ctx) {
        super(OpenShiftOperation.wrap(ctx));
    }

    public static OperationContext wrap(OperationContext context) {
        OpenShiftConfig config = OpenShiftConfig.wrap(context.getConfig());
        String oapiVersion = config.getOapiVersion();
        DefaultOpenShiftClient oc = new DefaultOpenShiftClient(context.getClient(), config);
        if (Utils.isNotNullOrEmpty((String)context.getApiGroupName()) && config.isOpenShiftAPIGroups(oc)) {
            String apiGroupUrl = URLUtils.join((String[])new String[]{config.getMasterUrl(), "apis", context.getApiGroupName(), oapiVersion});
            String apiGroupVersion = URLUtils.join((String[])new String[]{context.getApiGroupName(), oapiVersion});
            oc.close();
            return context.withConfig((Config)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(apiGroupVersion);
        }
        String apiGroupUrl = URLUtils.join((String[])new String[]{config.getMasterUrl(), "oapi", oapiVersion});
        oc.close();
        return context.withConfig((Config)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(oapiVersion);
    }

    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    public URL getRootUrl() {
        DefaultOpenShiftClient oc;
        OpenShiftConfig config = OpenShiftConfig.wrap(this.context.getConfig());
        if (config.isOpenShiftAPIGroups(oc = new DefaultOpenShiftClient(this.context.getClient(), config))) {
            oc.close();
            return super.getRootUrl();
        }
        oc.close();
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

