/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.internal.BuildConfigOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class BuildConfigHandler
implements ResourceHandler<BuildConfig, BuildConfigBuilder> {
    public String getKind() {
        return BuildConfig.class.getSimpleName();
    }

    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    public BuildConfig create(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (BuildConfig)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create((Object[])new BuildConfig[0]);
    }

    public BuildConfig replace(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (BuildConfig)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    public BuildConfig reload(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (BuildConfig)((Gettable)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public BuildConfigBuilder edit(BuildConfig item) {
        return new BuildConfigBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (Boolean)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete((Object[])new BuildConfig[]{item});
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, Watcher<BuildConfig> watcher) {
        return (Watch)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, String resourceVersion, Watcher<BuildConfig> watcher) {
        return (Watch)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public BuildConfig waitUntilReady(OkHttpClient client, Config config, String namespace, BuildConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (BuildConfig)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public BuildConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, BuildConfig item, Predicate<BuildConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (BuildConfig)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

