/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigFluent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.TlsVersion;

public class ConfigFluentImpl<A extends ConfigFluent<A>>
extends BaseFluent<A>
implements ConfigFluent<A> {
    private boolean trustCerts;
    private String masterUrl;
    private String apiVersion;
    private String namespace;
    private String caCertFile;
    private String caCertData;
    private String clientCertFile;
    private String clientCertData;
    private String clientKeyFile;
    private String clientKeyData;
    private String clientKeyAlgo;
    private String clientKeyPassphrase;
    private String username;
    private String password;
    private String oauthToken;
    private int watchReconnectInterval;
    private int watchReconnectLimit;
    private int connectionTimeout;
    private int requestTimeout;
    private long rollingTimeout;
    private long scaleTimeout;
    private int loggingInterval;
    private long websocketTimeout;
    private long websocketPingInterval;
    private String httpProxy;
    private String httpsProxy;
    private List<String> noProxy = new ArrayList<String>();
    private String userAgent;
    private List<TlsVersion> tlsVersions = new ArrayList<TlsVersion>();
    private Map<Integer, String> errorMessages = new LinkedHashMap<Integer, String>();

    public ConfigFluentImpl() {
    }

    public ConfigFluentImpl(Config instance) {
        this.withMasterUrl(instance.getMasterUrl());
        this.withApiVersion(instance.getApiVersion());
        this.withNamespace(instance.getNamespace());
        this.withTrustCerts(instance.isTrustCerts());
        this.withCaCertFile(instance.getCaCertFile());
        this.withCaCertData(instance.getCaCertData());
        this.withClientCertFile(instance.getClientCertFile());
        this.withClientCertData(instance.getClientCertData());
        this.withClientKeyFile(instance.getClientKeyFile());
        this.withClientKeyData(instance.getClientKeyData());
        this.withClientKeyAlgo(instance.getClientKeyAlgo());
        this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
        this.withUsername(instance.getUsername());
        this.withPassword(instance.getPassword());
        this.withOauthToken(instance.getOauthToken());
        this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        this.withConnectionTimeout(instance.getConnectionTimeout());
        this.withRequestTimeout(instance.getRequestTimeout());
        this.withRollingTimeout(instance.getRollingTimeout());
        this.withScaleTimeout(instance.getScaleTimeout());
        this.withLoggingInterval(instance.getLoggingInterval());
        this.withHttpProxy(instance.getHttpProxy());
        this.withHttpsProxy(instance.getHttpsProxy());
        this.withNoProxy(instance.getNoProxy());
        this.withErrorMessages(instance.getErrorMessages());
        this.withUserAgent(instance.getUserAgent());
        this.withTlsVersions(instance.getTlsVersions());
        this.withWebsocketTimeout(instance.getWebsocketTimeout());
        this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
    }

    @Override
    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    @Override
    public A withTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
        return (A)this;
    }

    @Override
    public String getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public A withMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
        return (A)this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public String getCaCertFile() {
        return this.caCertFile;
    }

    @Override
    public A withCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
        return (A)this;
    }

    @Override
    public String getCaCertData() {
        return this.caCertData;
    }

    @Override
    public A withCaCertData(String caCertData) {
        this.caCertData = caCertData;
        return (A)this;
    }

    @Override
    public String getClientCertFile() {
        return this.clientCertFile;
    }

    @Override
    public A withClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
        return (A)this;
    }

    @Override
    public String getClientCertData() {
        return this.clientCertData;
    }

    @Override
    public A withClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
        return (A)this;
    }

    @Override
    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    @Override
    public A withClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
        return (A)this;
    }

    @Override
    public String getClientKeyData() {
        return this.clientKeyData;
    }

    @Override
    public A withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (A)this;
    }

    @Override
    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    @Override
    public A withClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
        return (A)this;
    }

    @Override
    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    @Override
    public A withClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
        return (A)this;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public String getOauthToken() {
        return this.oauthToken;
    }

    @Override
    public A withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return (A)this;
    }

    @Override
    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    @Override
    public A withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)this;
    }

    @Override
    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    @Override
    public A withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)this;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public A withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return (A)this;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public A withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)this;
    }

    @Override
    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    @Override
    public A withRollingTimeout(long rollingTimeout) {
        this.rollingTimeout = rollingTimeout;
        return (A)this;
    }

    @Override
    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    @Override
    public A withScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)this;
    }

    @Override
    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    @Override
    public A withLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)this;
    }

    @Override
    public long getWebsocketTimeout() {
        return this.websocketTimeout;
    }

    @Override
    public A withWebsocketTimeout(long websocketTimeout) {
        this.websocketTimeout = websocketTimeout;
        return (A)this;
    }

    @Override
    public long getWebsocketPingInterval() {
        return this.websocketPingInterval;
    }

    @Override
    public A withWebsocketPingInterval(long websocketPingInterval) {
        this.websocketPingInterval = websocketPingInterval;
        return (A)this;
    }

    @Override
    public String getHttpProxy() {
        return this.httpProxy;
    }

    @Override
    public A withHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return (A)this;
    }

    @Override
    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    @Override
    public A withHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return (A)this;
    }

    @Override
    public A withNoProxy(String ... noProxy) {
        this.noProxy.clear();
        if (noProxy != null) {
            for (String item : noProxy) {
                this.addToNoProxy(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getNoProxy() {
        String[] result = new String[this.noProxy.size()];
        int index = 0;
        for (String item : this.noProxy) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToNoProxy(String ... items) {
        for (String item : items) {
            this.noProxy.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNoProxy(String ... items) {
        for (String item : items) {
            this.noProxy.remove(item);
        }
        return (A)this;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public A withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return (A)this;
    }

    @Override
    public A withTlsVersions(TlsVersion ... tlsVersions) {
        this.tlsVersions.clear();
        if (tlsVersions != null) {
            for (TlsVersion item : tlsVersions) {
                this.addToTlsVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public TlsVersion[] getTlsVersions() {
        TlsVersion[] result = new TlsVersion[this.tlsVersions.size()];
        int index = 0;
        for (TlsVersion item : this.tlsVersions) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToTlsVersions(TlsVersion ... items) {
        for (TlsVersion item : items) {
            this.tlsVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTlsVersions(TlsVersion ... items) {
        for (TlsVersion item : items) {
            this.tlsVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A addToErrorMessages(Integer key, String value) {
        if (key != null && value != null) {
            this.errorMessages.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToErrorMessages(Map<Integer, String> map) {
        if (map != null) {
            this.errorMessages.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromErrorMessages(Integer key) {
        if (key != null) {
            this.errorMessages.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromErrorMessages(Map<Integer, String> map) {
        if (map != null) {
            for (Integer key : map.keySet()) {
                this.errorMessages.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<Integer, String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public A withErrorMessages(Map<Integer, String> errorMessages) {
        this.errorMessages.clear();
        if (errorMessages != null) {
            this.errorMessages.putAll(errorMessages);
        }
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigFluentImpl that = (ConfigFluentImpl)o;
        if (this.trustCerts != that.trustCerts) {
            return false;
        }
        if (this.masterUrl != null ? !this.masterUrl.equals(that.masterUrl) : that.masterUrl != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.caCertFile != null ? !this.caCertFile.equals(that.caCertFile) : that.caCertFile != null) {
            return false;
        }
        if (this.caCertData != null ? !this.caCertData.equals(that.caCertData) : that.caCertData != null) {
            return false;
        }
        if (this.clientCertFile != null ? !this.clientCertFile.equals(that.clientCertFile) : that.clientCertFile != null) {
            return false;
        }
        if (this.clientCertData != null ? !this.clientCertData.equals(that.clientCertData) : that.clientCertData != null) {
            return false;
        }
        if (this.clientKeyFile != null ? !this.clientKeyFile.equals(that.clientKeyFile) : that.clientKeyFile != null) {
            return false;
        }
        if (this.clientKeyData != null ? !this.clientKeyData.equals(that.clientKeyData) : that.clientKeyData != null) {
            return false;
        }
        if (this.clientKeyAlgo != null ? !this.clientKeyAlgo.equals(that.clientKeyAlgo) : that.clientKeyAlgo != null) {
            return false;
        }
        if (this.clientKeyPassphrase != null ? !this.clientKeyPassphrase.equals(that.clientKeyPassphrase) : that.clientKeyPassphrase != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.rollingTimeout != that.rollingTimeout) {
            return false;
        }
        if (this.scaleTimeout != that.scaleTimeout) {
            return false;
        }
        if (this.loggingInterval != that.loggingInterval) {
            return false;
        }
        if (this.websocketTimeout != that.websocketTimeout) {
            return false;
        }
        if (this.websocketPingInterval != that.websocketPingInterval) {
            return false;
        }
        if (this.httpProxy != null ? !this.httpProxy.equals(that.httpProxy) : that.httpProxy != null) {
            return false;
        }
        if (this.httpsProxy != null ? !this.httpsProxy.equals(that.httpsProxy) : that.httpsProxy != null) {
            return false;
        }
        if (this.noProxy != null ? !this.noProxy.equals(that.noProxy) : that.noProxy != null) {
            return false;
        }
        if (this.userAgent != null ? !this.userAgent.equals(that.userAgent) : that.userAgent != null) {
            return false;
        }
        if (this.tlsVersions != null ? !this.tlsVersions.equals(that.tlsVersions) : that.tlsVersions != null) {
            return false;
        }
        return !(this.errorMessages != null ? !this.errorMessages.equals(that.errorMessages) : that.errorMessages != null);
    }
}

