/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.internal.URLUtils;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigOperation;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.openshift.client.dsl.internal.OpenshiftOperation;
import java.io.InputStream;
import java.net.URL;

public class BuildConfigOperationsImpl
extends OpenshiftOperation<OpenShiftClient, BuildConfig, BuildConfigList, DoneableBuildConfig, ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Void>>
implements BuildConfigOperation {
    private final String secret;
    private final String triggerType;

    public BuildConfigOperationsImpl(OpenShiftClient client) {
        this(client, client.getNamespace(), null, true, null, null, null);
    }

    public BuildConfigOperationsImpl(OpenShiftClient client, String namespace, String name, Boolean cascading, BuildConfig item, String secret, String triggerType) {
        super(client, "buildconfigs", namespace, name, cascading, item);
        this.triggerType = triggerType;
        this.secret = secret;
    }

    public ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Void> withName(String name) {
        return new BuildConfigOperationsImpl((OpenShiftClient)this.getClient(), this.getNamespace(), name, this.isCascading(), (BuildConfig)this.getItem(), this.secret, this.triggerType);
    }

    public ClientNonNamespaceOperation<OpenShiftClient, BuildConfig, BuildConfigList, DoneableBuildConfig, ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Void>> inNamespace(String namespace) {
        return new BuildConfigOperationsImpl((OpenShiftClient)this.getClient(), namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.secret, this.triggerType);
    }

    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl((OpenShiftClient)this.getClient(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), secret, this.triggerType);
    }

    public ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Void> load(InputStream is) {
        return new BuildConfigOperationsImpl((OpenShiftClient)this.getClient(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)((OpenShiftClient)this.getClient()).unmarshal(is, this.getType()), this.secret, this.triggerType);
    }

    public Void instantiate(BuildRequest request) {
        try {
            URL instantiationUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiate"}));
            AsyncHttpClient.BoundRequestBuilder requestBuilder = ((OpenShiftClient)this.getClient()).getHttpClient().preparePost(instantiationUrl.toString());
            requestBuilder.setBody(BaseOperation.mapper.writer().writeValueAsString((Object)request));
            this.handleResponse(requestBuilder, 201);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Void trigger(WebHookTrigger trigger) {
        try {
            String triggerUrl = URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "webhooks", this.secret, this.triggerType});
            AsyncHttpClient.BoundRequestBuilder requestBuilder = ((OpenShiftClient)this.getClient()).getHttpClient().preparePost(triggerUrl);
            requestBuilder.addHeader("Content-Type", "application/json");
            requestBuilder.addHeader("X-Github-Event", "push");
            requestBuilder.setBody(BaseOperation.mapper.writer().writeValueAsString((Object)trigger));
            ListenableFuture f = requestBuilder.execute();
            Response r = (Response)f.get();
            this.assertResponseCode(r, 200);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Triggerable<WebHookTrigger, Void> withType(String type) {
        return new BuildConfigOperationsImpl((OpenShiftClient)this.getClient(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.secret, type);
    }
}

