/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator.model;

import io.fabric8.kubernetes.schema.generator.ApiVersion;
import io.fabric8.kubernetes.schema.generator.ImportManager;
import io.fabric8.kubernetes.schema.generator.ImportOrderComparator;
import io.fabric8.kubernetes.schema.generator.model.JsonSubTypes;
import io.fabric8.kubernetes.schema.generator.schema.SchemaUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;

public class ClassInformation
implements ImportManager {
    private final SchemaUtils schemaUtils;
    private final Set<String> imports;
    private final String kubernetesListType;
    private final String packageName;
    private final Set<String> packageClasses;
    private final boolean inRootPackage;
    private final boolean isEnum;
    private final String enumValues;
    private final boolean isInterface;
    private final boolean isHasMetadata;
    private final boolean isNamespaced;
    private final String classType;
    private final String classSimpleName;
    private final String className;
    private final String implementsExtends;
    private final JsonSubTypes jsonSubTypes;

    ClassInformation(SchemaUtils schemaUtils, Map.Entry<String, Schema<?>> clazz, Set<String> processedEntries) {
        this.schemaUtils = schemaUtils;
        this.imports = new TreeSet<String>(new ImportOrderComparator());
        String classKey = clazz.getKey();
        Schema<?> classSchema = clazz.getValue();
        ApiVersion apiVersion = schemaUtils.getSettings().getApiVersions().get(classKey);
        this.packageName = schemaUtils.toModelPackage(classKey.substring(0, classKey.lastIndexOf(46)));
        this.packageClasses = this.resolvePackageClasses(processedEntries);
        this.kubernetesListType = apiVersion == null ? null : schemaUtils.kubernetesListType(this, classSchema);
        this.inRootPackage = this.getPackageName().equals(schemaUtils.getSettings().getPackageName());
        this.isEnum = SchemaUtils.isEnum(classSchema);
        if (this.isEnum) {
            this.addImport("com.fasterxml.jackson.annotation.JsonCreator");
            this.enumValues = String.join((CharSequence)",\n    ", SchemaUtils.enumValues(classSchema));
        } else {
            this.enumValues = null;
        }
        this.isInterface = SchemaUtils.isInterface(classSchema);
        this.isHasMetadata = apiVersion != null && this.kubernetesListType == null && schemaUtils.isHasMetadata(classSchema);
        this.isNamespaced = apiVersion != null && apiVersion.isNamespaced();
        this.classType = SchemaUtils.classType(classSchema);
        this.classSimpleName = schemaUtils.refToClassName(classKey);
        this.className = this.getPackageName() + "." + this.getClassSimpleName();
        this.implementsExtends = this.resolveImplementsExtends(classSchema);
        if (this.isInterface) {
            this.addImport("com.fasterxml.jackson.annotation.JsonSubTypes");
            this.addImport("com.fasterxml.jackson.annotation.JsonTypeInfo");
            this.addImport("com.fasterxml.jackson.databind.annotation.JsonTypeResolver");
            this.jsonSubTypes = new JsonSubTypes(schemaUtils, classSchema);
        } else {
            this.jsonSubTypes = null;
        }
    }

    @Override
    public boolean hasSimpleClassName(String className) {
        if (this.simpleClassName(className).equals(this.getClassSimpleName())) {
            return true;
        }
        return ImportManager.super.hasSimpleClassName(className);
    }

    boolean isEditable() {
        return !this.isEnum() && !this.isInterface();
    }

    public final String getBuilderName() {
        return this.getClassSimpleName() + "Builder";
    }

    private Set<String> resolvePackageClasses(Set<String> processedEntries) {
        TreeSet<String> ret = new TreeSet<String>();
        for (String entry : processedEntries) {
            String entryClassName = this.schemaUtils.refToModelPackage(entry);
            if (!entryClassName.substring(0, entryClassName.lastIndexOf(46)).equals(this.packageName)) continue;
            ret.add(entryClassName);
        }
        return ret;
    }

    private String resolveImplementsExtends(Schema<?> classSchema) {
        if (this.isEnum()) {
            return "";
        }
        StringBuilder implementsExtends = new StringBuilder();
        if (this.isInterface()) {
            implementsExtends.append("extends ");
        } else {
            implementsExtends.append("implements ");
        }
        String interfaceImplemented = this.schemaUtils.interfaceImplemented(classSchema);
        if (interfaceImplemented != null) {
            implementsExtends.append(interfaceImplemented).append(", ");
        }
        if (this.isEditable()) {
            this.addImport("com.fasterxml.jackson.annotation.JsonIgnore");
            this.addImport(this.schemaUtils.getSettings().getBuilderPackage() + ".Editable");
            implementsExtends.append("Editable<").append(this.getBuilderName()).append(">, ");
        }
        if (this.isHasMetadata()) {
            if (!this.isInRootPackage()) {
                this.addImport(this.schemaUtils.getSettings().getHasMetadataClass());
            }
            implementsExtends.append(this.schemaUtils.getSettings().getHasMetadataClassSimpleName());
        } else if (this.getClassSimpleName().equals(this.schemaUtils.getSettings().getKubernetesResourceClassSimpleName())) {
            implementsExtends.append(this.schemaUtils.getSettings().getKubernetesResourceClass());
        } else {
            if (!this.isInRootPackage()) {
                this.addImport(this.schemaUtils.getSettings().getKubernetesResourceClass());
            }
            implementsExtends.append(this.schemaUtils.getSettings().getKubernetesResourceClassSimpleName());
        }
        if (this.isNamespaced() && this.getKubernetesListType() == null) {
            if (!this.isInRootPackage()) {
                this.addImport(this.schemaUtils.getSettings().getNamespacedClass());
            }
            implementsExtends.append(", ").append(this.schemaUtils.getSettings().getNamespacedClassSimpleName());
        }
        if (this.getKubernetesListType() != null) {
            if (!this.isInRootPackage()) {
                this.addImport(this.schemaUtils.getSettings().getKubernetesResourceListClass());
            }
            implementsExtends.append(", ").append(this.schemaUtils.getSettings().getKubernetesResourceListClassSimpleName()).append("<").append(this.getPackageName()).append(".").append(this.getKubernetesListType()).append(">");
        }
        return implementsExtends.toString();
    }

    boolean hasOverride() {
        return this.schemaUtils.getSettings().getOverridesDirectory().toPath().resolve(this.getPackageName().replace('.', File.separatorChar)).resolve(this.getClassSimpleName().concat(".java")).toFile().exists();
    }

    @Generated
    public SchemaUtils getSchemaUtils() {
        return this.schemaUtils;
    }

    @Generated
    public Set<String> getImports() {
        return this.imports;
    }

    @Generated
    public String getKubernetesListType() {
        return this.kubernetesListType;
    }

    @Override
    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public Set<String> getPackageClasses() {
        return this.packageClasses;
    }

    @Generated
    public boolean isInRootPackage() {
        return this.inRootPackage;
    }

    @Generated
    public boolean isEnum() {
        return this.isEnum;
    }

    @Generated
    public String getEnumValues() {
        return this.enumValues;
    }

    @Generated
    public boolean isInterface() {
        return this.isInterface;
    }

    @Generated
    public boolean isHasMetadata() {
        return this.isHasMetadata;
    }

    @Generated
    public boolean isNamespaced() {
        return this.isNamespaced;
    }

    @Generated
    public String getClassType() {
        return this.classType;
    }

    @Generated
    public String getClassSimpleName() {
        return this.classSimpleName;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public String getImplementsExtends() {
        return this.implementsExtends;
    }

    @Generated
    public JsonSubTypes getJsonSubTypes() {
        return this.jsonSubTypes;
    }
}

