/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator;

import io.fabric8.kubernetes.schema.generator.GeneratorException;
import io.fabric8.kubernetes.schema.generator.GeneratorSettings;
import io.fabric8.kubernetes.schema.generator.schema.CrdParser;
import io.fabric8.kubernetes.schema.generator.schema.SchemaFlattener;
import io.fabric8.kubernetes.schema.generator.schema.SchemaUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class GeneratorUtils {
    private final GeneratorSettings settings;

    public GeneratorUtils(GeneratorSettings settings) {
        this.settings = settings;
    }

    public static Predicate<? super Map.Entry<String, ?>> filter(GeneratorSettings gs) {
        return e -> {
            for (String regex : gs.getSkipGenerationRegexes()) {
                if (!((String)e.getKey()).matches(regex)) continue;
                return false;
            }
            if (gs.getIncludeGenerationRegexes().isEmpty()) {
                return true;
            }
            for (String regex : gs.getIncludeGenerationRegexes()) {
                if (!((String)e.getKey()).matches(regex)) continue;
                return true;
            }
            return false;
        };
    }

    public String readTemplate(String name) {
        String string;
        block8: {
            InputStream stream = Objects.requireNonNull(SchemaUtils.class.getResourceAsStream("/templates/" + name + ".mustache"));
            try {
                string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.settings.getLogger().severe(ex.getMessage());
                    throw new GeneratorException("Can't load template " + name);
                }
            }
            stream.close();
        }
        return string;
    }

    public final void writeFile(Path file, String fileContents) {
        try {
            Files.write(file, fileContents.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            this.settings.getLogger().severe(ex.getMessage());
            throw new GeneratorException("Can't write java generated class " + file.toString());
        }
    }

    public static void cleanSourceDirectory(File sourceDirectory) {
        try {
            FileUtils.deleteDirectory((File)sourceDirectory);
        }
        catch (IOException ex) {
            throw new GeneratorException("Can't clean existent generated sources");
        }
    }

    public static OpenAPI parse(File schema) {
        if (schema == null || !schema.exists()) {
            throw new IllegalArgumentException("Schema file not found: " + String.valueOf(schema));
        }
        return GeneratorUtils.parse(schema.toURI());
    }

    public static OpenAPI parse(URI uri) {
        OpenAPI openApi;
        Objects.requireNonNull(uri, "A valid URL is required for OpenAPI parsing");
        if (uri.getPath().toLowerCase().matches(".+\\.ya?ml$")) {
            try {
                openApi = CrdParser.crdToOpenApi(uri);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error parsing CRD file: " + String.valueOf(uri), e);
            }
        } else {
            openApi = new OpenAPIV3Parser().read(uri.toString());
        }
        SchemaFlattener.flatten(openApi);
        return openApi;
    }
}

