/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq.core;

import io.fabric8.mq.core.MQs;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;

public class MQConnectionFactory
extends ActiveMQConnectionFactory {
    private String serviceName;
    private String failoverUrlParameters;

    public MQConnectionFactory() {
    }

    public MQConnectionFactory(String userName, String password) {
        this();
        this.setUserName(userName);
        this.setPassword(password);
    }

    public String getBrokerURL() {
        return MQs.getBrokerURL(this.getServiceName(), this.getFailoverUrlParameters());
    }

    public Connection createConnection() throws JMSException {
        String url = this.getBrokerURL();
        this.setBrokerURL(url);
        return super.createActiveMQConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        String url = this.getBrokerURL();
        this.setBrokerURL(url);
        return super.createActiveMQConnection(userName, password);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getFailoverUrlParameters() {
        return this.failoverUrlParameters;
    }

    public void setFailoverUrlParameters(String failoverUrlParameters) {
        this.failoverUrlParameters = failoverUrlParameters;
    }
}

