/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq.core;

import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQs {
    private static final transient Logger LOG = LoggerFactory.getLogger(MQs.class);
    public static final String SERVICE_NAME_ENV_VAR = "FABRIC8MQ_SERVICE_NAME";
    public static final String DEFAULT_SERVICE_NAME = "FABRIC8MQ";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final String DEFAULT_PORT = "61616";

    public static String getBrokerURL(String serviceName, String parameters) {
        if (parameters == null) {
            parameters = "";
        }
        if (Strings.isNullOrBlank((String)serviceName)) {
            serviceName = Systems.getEnvVarOrSystemProperty((String)SERVICE_NAME_ENV_VAR, (String)SERVICE_NAME_ENV_VAR, (String)DEFAULT_SERVICE_NAME);
        }
        String serviceEnvVarPrefix = MQs.getServiceEnvVarPrefix(serviceName);
        String hostEnvVar = serviceEnvVarPrefix + "_HOST";
        String portEnvVar = serviceEnvVarPrefix + "_PORT";
        String host = Systems.getEnvVarOrSystemProperty((String)hostEnvVar, (String)hostEnvVar, (String)DEFAULT_HOST);
        String port = Systems.getEnvVarOrSystemProperty((String)portEnvVar, (String)portEnvVar, (String)DEFAULT_PORT);
        LOG.info("Connecting to ActiveMQ broker on " + host + ":" + port + " from $" + hostEnvVar + " and $" + portEnvVar + ". To use a different broker service please specify $" + SERVICE_NAME_ENV_VAR + "=someBrokerServiceName where 'someBrokerServiceName' is a defined ActiveMQ broker service in Kubernetes");
        String answer = "failover:(tcp://" + host + ":" + port + ")" + parameters;
        LOG.info("BrokerURL is: " + answer);
        return answer;
    }

    protected static String getServiceEnvVarPrefix(String serviceName) {
        return serviceName.toUpperCase() + "_SERVICE";
    }
}

