/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ByteString {
    private final byte[] data;

    private ByteString(byte[] data) {
        this.data = data;
    }

    public static ByteString of(byte ... data) {
        Objects.requireNonNull(data, "data === null");
        return new ByteString((byte[])data.clone());
    }

    public static ByteString encodeUtf8(String s) {
        Objects.requireNonNull(s, "s === null");
        return new ByteString(s.getBytes(StandardCharsets.UTF_8));
    }

    public final String utf8() {
        return new String(this.data, StandardCharsets.UTF_8);
    }

    public final byte[] toByteArray() {
        return (byte[])this.data.clone();
    }
}

