/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver;

import io.fabric8.mockwebserver.MockWebServerListener;
import io.fabric8.mockwebserver.http.Dispatcher;
import io.fabric8.mockwebserver.http.HttpUrl;
import io.fabric8.mockwebserver.http.MockResponse;
import io.fabric8.mockwebserver.http.QueueDispatcher;
import io.fabric8.mockwebserver.http.RecordedHttpConnection;
import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.vertx.HttpServerRequestHandler;
import io.fabric8.mockwebserver.vertx.Protocol;
import io.netty.handler.ssl.ClientAuth;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.SelfSignedCertificate;
import io.vertx.core.net.TrustOptions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MockWebServer
implements Closeable {
    private static final String[] SUPPORTED_WEBSOCKET_SUB_PROTOCOLS = new String[]{"v1.channel.k8s.io", "v2.channel.k8s.io", "v3.channel.k8s.io", "v4.channel.k8s.io"};
    private static final Logger logger = Logger.getLogger(MockWebServer.class.getName());
    private final Vertx vertx = Vertx.vertx();
    private final BlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue<RecordedRequest>();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final List<MockWebServerListener> listeners = new ArrayList<MockWebServerListener>();
    private Dispatcher dispatcher = new QueueDispatcher();
    private ClientAuth clientAuth = ClientAuth.NONE;
    private final List<String> enabledSecuredTransportProtocols = new ArrayList<String>();
    private boolean ssl;
    private SelfSignedCertificate selfSignedCertificate;
    private HttpServer httpServer;
    private int port;
    private InetAddress inetAddress;
    private String hostName;
    private List<Protocol> protocols;
    private boolean started;

    public MockWebServer() {
        this.enabledSecuredTransportProtocols.addAll(SSLOptions.DEFAULT_ENABLED_SECURE_TRANSPORT_PROTOCOLS);
        this.protocols = Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1);
    }

    private void before() {
        if (this.started) {
            return;
        }
        this.start();
    }

    public void start() {
        this.start(0);
    }

    public void start(int port) {
        this.start(InetAddress.getLoopbackAddress(), port);
    }

    public synchronized void start(InetAddress inetAddress, int port) {
        if (this.started) {
            throw new IllegalStateException("start() already called");
        }
        this.started = true;
        this.inetAddress = inetAddress;
        this.hostName = inetAddress.getHostName().equals("127.0.0.1") ? "localhost" : inetAddress.getHostName();
        HttpServerOptions options = new HttpServerOptions().setHost(inetAddress.getHostAddress()).setPort(port).setAlpnVersions(this.protocols.stream().map(Protocol::getHttpVersion).collect(Collectors.toList())).setWebSocketSubProtocols(Arrays.asList(SUPPORTED_WEBSOCKET_SUB_PROTOCOLS)).setHandle100ContinueAutomatically(true);
        if (this.ssl) {
            this.selfSignedCertificate = SelfSignedCertificate.create((String)this.getHostName());
            options.setSsl(true).setEnabledSecureTransportProtocols(new HashSet<String>(this.enabledSecuredTransportProtocols)).setTrustOptions((TrustOptions)this.selfSignedCertificate.trustOptions()).setKeyCertOptions((KeyCertOptions)this.selfSignedCertificate.keyCertOptions());
        }
        this.httpServer = this.vertx.createHttpServer(options);
        this.httpServer.connectionHandler(event -> {
            RecordedHttpConnection connection = new RecordedHttpConnection(event.remoteAddress(), event.localAddress(), this.ssl);
            this.listeners.forEach(listener -> listener.onConnection(connection));
            event.closeHandler(res -> this.listeners.forEach(listener -> listener.onConnectionClosed(connection)));
        });
        this.httpServer.requestHandler((Handler)new HttpServerRequestHandler(this.vertx){

            @Override
            protected MockResponse onHttpRequest(RecordedRequest request) {
                MockWebServer.this.requestCount.incrementAndGet();
                MockWebServer.this.requestQueue.add(request);
                MockResponse response = MockWebServer.this.dispatcher.dispatch(request);
                MockWebServer.this.info("received request: %s and responded: %s", request.toString(), response.toString());
                return response;
            }
        });
        MockWebServer.await(this.httpServer.listen(), "Unable to start MockWebServer");
        this.port = this.httpServer.actualPort();
        this.info("starting to accept connections on %s", this.getHostName());
    }

    public synchronized void shutdown() {
        if (!this.started) {
            return;
        }
        if (this.httpServer == null) {
            throw new IllegalStateException("shutdown() before start()");
        }
        this.dispatcher.shutdown();
        Future httpClose = this.httpServer.close();
        Handler onComplete = v -> {
            this.vertx.close();
            this.info("done accepting connections", new String[0]);
        };
        if (httpClose.isComplete()) {
            onComplete.handle((Object)httpClose);
        } else {
            httpClose.onComplete(onComplete);
            MockWebServer.await(httpClose, "Unable to close MockWebServer");
        }
        MockWebServer.await(this.vertx.close(), "Unable to close Vertx");
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public int getPort() {
        this.before();
        return this.port;
    }

    public String getHostName() {
        this.before();
        return this.hostName;
    }

    public Proxy toProxyAddress() {
        this.before();
        InetSocketAddress address = new InetSocketAddress(this.getHostName(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, address);
    }

    public SelfSignedCertificate getSelfSignedCertificate() {
        return this.selfSignedCertificate;
    }

    public HttpUrl url(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String schema = this.ssl ? "https" : "http";
        return HttpUrl.parse(schema + "://" + this.getHostName() + ":" + this.getPort() + "/" + path);
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.requestQueue.take();
    }

    public RecordedRequest takeRequest(long timeout, TimeUnit unit) throws InterruptedException {
        return this.requestQueue.poll(timeout, unit);
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public void useHttps() {
        this.ssl = true;
    }

    public void enqueue(MockResponse response) {
        if (!(this.dispatcher instanceof QueueDispatcher)) {
            throw new IllegalStateException("Dispatcher is not a QueueDispatcher");
        }
        ((QueueDispatcher)this.dispatcher).enqueueResponse(response);
    }

    public void addListener(MockWebServerListener listener) {
        this.listeners.add(listener);
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
    }

    private static <T> T await(Future<T> vertxFuture, String errorMessage) {
        CompletableFuture future = new CompletableFuture();
        vertxFuture.onComplete(r -> {
            if (r.succeeded()) {
                future.complete(r.result());
            } else {
                future.completeExceptionally(r.cause());
            }
        });
        try {
            return future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IllegalStateException(errorMessage, e);
        }
    }

    private void info(String log, String ... parameters) {
        if (logger.isLoggable(Level.INFO)) {
            String formatMessage = "%s " + log;
            Object[] allParams = Arrays.copyOf(new String[]{this.toString()}, parameters.length + 1);
            System.arraycopy(parameters, 0, allParams, 1, parameters.length);
            logger.info(String.format(formatMessage, allParams));
        }
    }

    public String toString() {
        return "MockWebServer[" + this.getPort() + "]";
    }
}

