/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.vertx;

import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.http.WebSocket;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;

public class VertxMockWebSocket
implements WebSocket {
    private final RecordedRequest request;
    private final ServerWebSocket webSocket;
    private volatile boolean closing;

    public VertxMockWebSocket(RecordedRequest request, ServerWebSocket webSocket) {
        this.request = request;
        this.webSocket = webSocket;
        this.closing = false;
    }

    @Override
    public RecordedRequest request() {
        return this.request;
    }

    @Override
    public boolean send(String text) {
        Future send = this.webSocket.writeTextMessage(text);
        if (send.isComplete()) {
            return send.succeeded();
        }
        return true;
    }

    @Override
    public boolean send(byte[] bytes) {
        Future send = this.webSocket.writeBinaryMessage(Buffer.buffer((byte[])bytes));
        if (send.isComplete()) {
            return send.succeeded();
        }
        return true;
    }

    @Override
    public synchronized boolean close(int code, String reason) {
        if (!this.closing) {
            this.closing = true;
            this.webSocket.close((short)code, reason);
        }
        return true;
    }
}

