/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.crud;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.MockServerException;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import io.fabric8.zjsonpatch.JsonPatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;

public class CrudDispatcher
extends Dispatcher {
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String PATCH = "PATCH";
    private static final String GET = "GET";
    private static final String DELETE = "DELETE";
    protected final Map<AttributeSet, String> map = Collections.synchronizedMap(new LinkedHashMap());
    protected final Context context;
    protected final AttributeExtractor attributeExtractor;
    protected final ResponseComposer responseComposer;

    public CrudDispatcher(Context context, AttributeExtractor attributeExtractor, ResponseComposer responseComposer) {
        this.context = context;
        this.attributeExtractor = attributeExtractor;
        this.responseComposer = responseComposer;
    }

    public MockResponse dispatch(RecordedRequest request) {
        String path = request.getPath();
        switch (request.getMethod().toUpperCase()) {
            case "POST": {
                return this.handleCreate(path, request.getBody().readUtf8());
            }
            case "PUT": {
                return this.handleUpdate(path, request.getBody().readUtf8());
            }
            case "PATCH": {
                return this.handlePatch(path, request.getBody().readUtf8());
            }
            case "GET": {
                return this.handleGet(path);
            }
            case "DELETE": {
                return this.handleDelete(path);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockResponse handleCreate(String path, String body) {
        MockResponse response = new MockResponse();
        AttributeSet features = AttributeSet.merge(this.attributeExtractor.fromPath(path), this.attributeExtractor.fromResource(body));
        Map<AttributeSet, String> map = this.map;
        synchronized (map) {
            this.map.put(features, body);
        }
        response.setBody(body);
        response.setResponseCode(202);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockResponse handlePatch(String path, String body) {
        MockResponse response = new MockResponse();
        String existingObjectBody = this.doGet(path);
        if (existingObjectBody == null) {
            response.setResponseCode(404);
        } else {
            try {
                JsonNode patch = this.context.getMapper().readTree(body);
                JsonNode source = this.context.getMapper().readTree(existingObjectBody);
                JsonNode updated = JsonPatch.apply((JsonNode)patch, (JsonNode)source);
                String updatedAsString = this.context.getMapper().writeValueAsString((Object)updated);
                AttributeSet features = AttributeSet.merge(this.attributeExtractor.fromPath(path), this.attributeExtractor.fromResource(updatedAsString));
                Map<AttributeSet, String> map = this.map;
                synchronized (map) {
                    this.map.put(features, updatedAsString);
                }
                response.setResponseCode(202);
                response.setBody(updatedAsString);
            }
            catch (Exception e) {
                throw new MockServerException("Exception when handling CRUD patch", e);
            }
        }
        return response;
    }

    public MockResponse handleUpdate(String path, String body) {
        String currentItem = this.doGet(path);
        MockResponse response = this.handleCreate(path, body);
        if (currentItem == null) {
            response.setResponseCode(201);
        }
        return response;
    }

    public MockResponse handleGet(String path) {
        MockResponse response = new MockResponse();
        String body = this.doGet(path);
        if (body == null) {
            response.setResponseCode(404);
        } else {
            response.setResponseCode(200);
            response.setBody(body);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockResponse handleDelete(String path) {
        MockResponse response = new MockResponse();
        ArrayList<AttributeSet> items = new ArrayList<AttributeSet>();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        Map<AttributeSet, String> map = this.map;
        synchronized (map) {
            for (Map.Entry<AttributeSet, String> entry : this.map.entrySet()) {
                if (!entry.getKey().matches(query)) continue;
                items.add(entry.getKey());
            }
            if (!items.isEmpty()) {
                for (AttributeSet item : items) {
                    this.map.remove(item);
                }
                response.setResponseCode(200);
            } else {
                response.setResponseCode(404);
            }
        }
        return response;
    }

    public Map<AttributeSet, String> getMap() {
        return this.map;
    }

    public AttributeExtractor getAttributeExtractor() {
        return this.attributeExtractor;
    }

    public ResponseComposer getResponseComposer() {
        return this.responseComposer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doGet(String path) {
        ArrayList<String> items = new ArrayList<String>();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        Map<AttributeSet, String> map = this.map;
        synchronized (map) {
            for (Map.Entry<AttributeSet, String> entry : this.map.entrySet()) {
                if (!entry.getKey().matches(query)) continue;
                items.add(entry.getValue());
            }
        }
        if (items.isEmpty()) {
            return null;
        }
        if (items.size() == 1) {
            return (String)items.get(0);
        }
        return this.responseComposer.compose(items);
    }
}

