/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import io.fabric8.mockwebserver.internal.WebSocketMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.RecordedRequest;
import okio.ByteString;

public class WebSocketSession
extends WebSocketListener {
    private final List<WebSocketMessage> open;
    private final WebSocketMessage failure;
    private final Exception cause;
    private final Map<Object, Queue<WebSocketMessage>> requestEvents = new HashMap<Object, Queue<WebSocketMessage>>();
    private final Map<Object, Queue<WebSocketMessage>> sentWebSocketMessagesRequestEvents = new HashMap<Object, Queue<WebSocketMessage>>();
    private final Map<SimpleRequest, Queue<WebSocketMessage>> httpRequestEvents = new HashMap<SimpleRequest, Queue<WebSocketMessage>>();
    private final List<WebSocketMessage> timedEvents = new ArrayList<WebSocketMessage>();
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ScheduledExecutorService executor;
    private final Context context;

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.webSocketRef.get().close(code, reason);
    }

    public WebSocketSession(Context context, ScheduledExecutorService executor, List<WebSocketMessage> open, WebSocketMessage failure, Exception cause) {
        this.context = context;
        this.open = open;
        this.failure = failure;
        this.cause = cause;
        this.executor = executor;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.webSocketRef.set(webSocket);
        for (WebSocketMessage msg : this.open) {
            this.send(msg);
        }
        for (WebSocketMessage msg : this.timedEvents) {
            this.send(msg);
        }
        this.checkIfShouldClose();
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.onMessage(webSocket, bytes.utf8());
    }

    public void onMessage(WebSocket webSocket, String in) {
        Queue<WebSocketMessage> queue = this.requestEvents.get(in);
        this.send(queue, in);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
    }

    private void send(Queue<WebSocketMessage> queue, String in) {
        if (queue != null && !queue.isEmpty()) {
            WebSocketMessage msg = queue.peek();
            this.send(msg);
            if (msg.isToBeRemoved()) {
                queue.remove();
            }
            this.checkIfShouldSendAgain(msg);
            this.checkIfShouldClose();
        } else {
            this.webSocketRef.get().close(1002, "Unexpected message:" + in);
        }
    }

    private void checkIfShouldSendAgain(WebSocketMessage msg) {
        String text;
        String string = text = msg.isBinary() ? ByteString.of((byte[])msg.getBytes()).utf8() : msg.getBody();
        if (this.sentWebSocketMessagesRequestEvents.containsKey(text)) {
            Queue<WebSocketMessage> queue = this.sentWebSocketMessagesRequestEvents.get(text);
            this.send(queue, text);
        }
    }

    public void dispatch(RecordedRequest request) {
        HttpMethod method = HttpMethod.valueOf(request.getMethod());
        String path = request.getPath();
        SimpleRequest key = new SimpleRequest(method, path);
        SimpleRequest keyForAnyMethod = new SimpleRequest(path);
        if (this.httpRequestEvents.containsKey(key)) {
            Queue<WebSocketMessage> queue = this.httpRequestEvents.get(key);
            this.send(queue, "from http " + path);
        } else if (this.httpRequestEvents.containsKey(keyForAnyMethod)) {
            Queue<WebSocketMessage> queue = this.httpRequestEvents.get(keyForAnyMethod);
            this.send(queue, "from http " + path);
        }
    }

    public List<WebSocketMessage> getOpen() {
        return this.open;
    }

    public WebSocketMessage getFailure() {
        return this.failure;
    }

    public Exception getCause() {
        return this.cause;
    }

    public Map<Object, Queue<WebSocketMessage>> getRequestEvents() {
        return this.requestEvents;
    }

    public List<WebSocketMessage> getTimedEvents() {
        return this.timedEvents;
    }

    public Map<Object, Queue<WebSocketMessage>> getSentWebSocketMessagesRequestEvents() {
        return this.sentWebSocketMessagesRequestEvents;
    }

    public Map<SimpleRequest, Queue<WebSocketMessage>> getHttpRequestEvents() {
        return this.httpRequestEvents;
    }

    private void checkIfShouldClose() {
        if (this.requestEvents.isEmpty() && this.httpRequestEvents.isEmpty() && this.sentWebSocketMessagesRequestEvents.isEmpty()) {
            try {
                this.executor.shutdown();
                if (this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                    this.webSocketRef.get().close(1000, "Closing...");
                } else {
                    this.executor.shutdownNow();
                    this.webSocketRef.get().close(1000, "Closing...");
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private void send(final WebSocketMessage message) {
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                WebSocket ws = (WebSocket)WebSocketSession.this.webSocketRef.get();
                if (ws != null) {
                    if (message.isBinary()) {
                        ws.send(ByteString.of((byte[])message.getBytes()));
                    } else {
                        ws.send(message.getBody());
                    }
                }
            }
        }, (long)message.getDelay(), TimeUnit.MILLISECONDS);
    }
}

