/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import io.fabric8.mockwebserver.ServerResponse;
import java.util.Arrays;
import java.util.List;
import okhttp3.mockwebserver.MockResponse;

public class ChunkedResponse
implements ServerResponse {
    private static final int DEFAULT_MAX_CHUNK_SIZE = 204800;
    private final int statusCode;
    private final List<String> body;
    private final boolean repeatable;

    public ChunkedResponse(boolean repeatable, int statusCode, String ... body) {
        this.statusCode = statusCode;
        this.body = Arrays.asList(body);
        this.repeatable = repeatable;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public List<String> getBody() {
        return this.body;
    }

    @Override
    public MockResponse toMockResponse() {
        MockResponse mockResponse = new MockResponse();
        mockResponse.setChunkedBody(this.concatBody(), 204800);
        mockResponse.setResponseCode(this.statusCode);
        return mockResponse;
    }

    private String concatBody() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.body) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }
}

