/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.crud;

import io.fabric8.mockwebserver.crud.Attribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class AttributeSet {
    private final Set<Attribute> attributes;

    public static AttributeSet merge(AttributeSet ... attributeSets) {
        LinkedHashSet<Attribute> all = new LinkedHashSet<Attribute>();
        for (AttributeSet f : attributeSets) {
            all.addAll(f.attributes);
        }
        return new AttributeSet(all);
    }

    public AttributeSet(Attribute ... attributes) {
        this(Arrays.asList(attributes));
    }

    public AttributeSet(Collection<Attribute> attributes) {
        this.attributes = attributes == null ? new LinkedHashSet<Attribute>() : new LinkedHashSet<Attribute>(attributes);
    }

    public AttributeSet add(Attribute ... attr) {
        LinkedHashSet<Attribute> all = new LinkedHashSet<Attribute>(this.attributes);
        for (Attribute a : attr) {
            all.add(a);
        }
        return new AttributeSet(all);
    }

    public boolean matches(AttributeSet candidate) {
        for (Attribute c : candidate.attributes) {
            boolean found = false;
            for (Attribute a : this.attributes) {
                if (!c.equals(a)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeSet that = (AttributeSet)o;
        return this.attributes != null ? this.attributes.equals(that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }
}

