/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.builder;

import io.fabric8.mockwebserver.builder.Builder;
import io.fabric8.mockwebserver.builder.Fluent;
import io.fabric8.mockwebserver.builder.TypedVisitor;
import io.fabric8.mockwebserver.builder.Visitable;
import io.fabric8.mockwebserver.builder.Visitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class BaseFluent<T>
implements Fluent<T>,
Visitable<T> {
    public final List<Visitable> _visitables = new ArrayList<Visitable>();

    public <T> ArrayList<T> build(List<? extends Builder<? extends T>> list) {
        ArrayList<T> r = new ArrayList<T>();
        for (Builder<T> b : list) {
            r.add(b.build());
        }
        return r;
    }

    public <T> LinkedHashSet<T> build(LinkedHashSet<? extends Builder<T>> set) {
        LinkedHashSet r = new LinkedHashSet();
        for (Builder builder : set) {
            r.add(builder.build());
        }
        return r;
    }

    public <T> ArrayList<T> aggregate(List<? extends T> ... lists) {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (List<? extends T> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    public <T> LinkedHashSet<T> aggregate(Set<? extends T> ... sets) {
        LinkedHashSet<? extends T> result = new LinkedHashSet<T>();
        for (Set<? extends T> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    private static <V, F> Boolean canVisit(V visitor, F fluent) {
        for (Method method : visitor.getClass().getDeclaredMethods()) {
            if (visitor instanceof TypedVisitor) {
                return ((TypedVisitor)visitor).getType().isAssignableFrom(fluent.getClass());
            }
            if (method.getParameterTypes().length != 1) continue;
            Class<?> visitorType = method.getParameterTypes()[0];
            if (visitorType.isAssignableFrom(fluent.getClass())) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public T accept(Visitor visitor) {
        for (Visitable v : this._visitables) {
            v.accept(visitor);
        }
        if (BaseFluent.canVisit(visitor, this).booleanValue()) {
            visitor.visit(this);
        }
        return (T)this;
    }
}

