/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.letschat;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.letschat.LetsChatClient;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LetsChatKubernetes {
    private static final transient Logger LOG = LoggerFactory.getLogger(LetsChatKubernetes.class);

    public static LetsChatClient createLetsChat(KubernetesClient kubernetes) {
        String userName = Systems.getEnvVarOrSystemProperty((String)"LETSCHAT_USERNAME", (String)"admin");
        String password = Systems.getEnvVarOrSystemProperty((String)"LETSCHAT_PASSWORD", (String)"123123");
        String token = Systems.getEnvVarOrSystemProperty((String)"LETSCHAT_TOKEN");
        String namespace = kubernetes.getNamespace();
        String address = kubernetes.getServiceURL("letschat", namespace, "http", true);
        if (Strings.isNullOrBlank((String)address)) {
            LOG.warn("No LetsChat service could be found in kubernetes " + namespace + " on address: " + kubernetes.getAddress());
            return null;
        }
        LOG.info("Logging into LetsChat at " + address + " as user " + userName);
        return new LetsChatClient(address, userName, password, token);
    }
}

