/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.template;

import io.fabric8.kubernetes.template.GenerateTemplateDTO;
import io.fabric8.utils.Files;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

public class TemplateGenerator {
    public static final String DEFAULT_TEMPLATE = "io/fabric8/templates/default.mvel";
    public static final String DOCKER_DATA_IMAGE = "docker_image";
    private final GenerateTemplateDTO config;
    private final List<ClassLoader> classLoaders;

    public TemplateGenerator(GenerateTemplateDTO config) {
        this(config, TemplateGenerator.createDefaultClassLoaders());
    }

    public TemplateGenerator(GenerateTemplateDTO config, List<ClassLoader> classLoaders) {
        this.config = config;
        this.classLoaders = classLoaders;
    }

    private static List<ClassLoader> createDefaultClassLoaders() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(TemplateGenerator.class.getClassLoader());
        return classLoaders;
    }

    public void generate(File kubernetesJson) throws IllegalArgumentException {
        String template = this.config.getTemplate();
        String dockerImage = this.config.getDockerImage();
        if (Strings.isNullOrBlank((String)template)) {
            throw new IllegalArgumentException("No fabric8.template specified so cannot generate the Kubernetes JSON file!");
        }
        InputStream in = this.loadTemplate(template);
        if (in == null) {
            throw new IllegalArgumentException("Could not find template: " + template + " on the ClassPath when trying to generate the Kubernetes JSON!");
        }
        ParserContext parserContext = new ParserContext();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(this.config.getTemplateVariables());
        if (Strings.isNotBlank((String)dockerImage)) {
            TemplateGenerator.addIfNotDefined(variables, DOCKER_DATA_IMAGE, dockerImage);
        }
        Objects.notNull(variables.get(DOCKER_DATA_IMAGE), (String)"no docker.image property specified!");
        String name = this.config.getName();
        TemplateGenerator.addIfNotDefined(variables, "name", name);
        TemplateGenerator.addIfNotDefined(variables, "containerName", this.config.getContainerName());
        Map<String, String> labels = this.config.getLabels();
        TemplateGenerator.addIfNotDefined(labels, "name", name);
        variables.put("labels", labels);
        variables.put("ports", this.config.getPorts());
        variables.put("replicaCount", this.config.getReplicaCount());
        variables.put("environmentVariables", this.config.getEnvironmentVariables());
        variables.put("serviceName", this.config.getServiceName());
        variables.put("servicePort", this.config.getServicePort());
        variables.put("serviceContainerPort", this.config.getServiceContainerPort());
        variables.put("imagePullPolicy", this.config.getImagePullPolicy());
        try {
            String answer;
            CompiledTemplate compiledTemplate = TemplateCompiler.compileTemplate((InputStream)in, (ParserContext)parserContext);
            String generated = answer = TemplateRuntime.execute((CompiledTemplate)compiledTemplate, (Object)parserContext, variables).toString();
            Files.writeToFile((File)kubernetesJson, (String)generated, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to generate Kubernetes JSON from template " + template + ". " + e, e);
        }
    }

    protected InputStream loadTemplate(String template) {
        for (ClassLoader classLoader : this.classLoaders) {
            InputStream answer = classLoader.getResourceAsStream(template);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    protected static <T> void addIfNotDefined(Map<String, T> map, String key, T value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }
}

