/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.StatusCondition;
import io.fabric8.openshift.api.model.tuned.v1.StatusConditionBuilder;
import io.fabric8.openshift.api.model.tuned.v1.StatusConditionFluent;
import io.fabric8.openshift.api.model.tuned.v1.TunedStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TunedStatusFluent<A extends TunedStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<StatusConditionBuilder> conditions = new ArrayList();

    public TunedStatusFluent() {
    }

    public TunedStatusFluent(TunedStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<StatusCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (StatusCondition item : items) {
            StatusConditionBuilder builder = new StatusConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new StatusCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewConditionLike(StatusCondition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToConditions(StatusCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (StatusCondition item : items) {
            StatusConditionBuilder builder = new StatusConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addToConditions(int index, StatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        StatusConditionBuilder builder = new StatusConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public StatusCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<StatusCondition> buildConditions() {
        return this.conditions != null ? TunedStatusFluent.build(this.conditions) : null;
    }

    public StatusCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public StatusCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public StatusCondition buildMatchingCondition(Predicate<StatusConditionBuilder> predicate) {
        for (StatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(TunedStatus instance) {
        TunedStatus tunedStatus = instance = instance != null ? instance : new TunedStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<StatusConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TunedStatusFluent that = (TunedStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasMatchingCondition(Predicate<StatusConditionBuilder> predicate) {
        for (StatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<StatusCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (StatusCondition item : items) {
            StatusConditionBuilder builder = new StatusConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromConditions(StatusCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (StatusCondition item : items) {
            StatusConditionBuilder builder = new StatusConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<StatusConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<StatusConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            StatusConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ConditionsNested<A> setNewConditionLike(int index, StatusCondition item) {
        return new ConditionsNested(index, item);
    }

    public A setToConditions(int index, StatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        StatusConditionBuilder builder = new StatusConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withConditions(List<StatusCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (StatusCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(StatusCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (StatusCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public class ConditionsNested<N>
    extends StatusConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        StatusConditionBuilder builder;
        int index;

        ConditionsNested(int index, StatusCondition item) {
            this.index = index;
            this.builder = new StatusConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TunedStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

