/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.ProfileConfig;
import io.fabric8.openshift.api.model.tuned.v1.TuneDConfig;
import io.fabric8.openshift.api.model.tuned.v1.TuneDConfigBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TuneDConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProfileConfigFluent<A extends ProfileConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean debug;
    private String providerName;
    private TuneDConfigBuilder tunedConfig;
    private String tunedProfile;
    private Integer verbosity;

    public ProfileConfigFluent() {
    }

    public ProfileConfigFluent(ProfileConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public TuneDConfig buildTunedConfig() {
        return this.tunedConfig != null ? this.tunedConfig.build() : null;
    }

    protected void copyInstance(ProfileConfig instance) {
        ProfileConfig profileConfig = instance = instance != null ? instance : new ProfileConfig();
        if (instance != null) {
            this.withDebug(instance.getDebug());
            this.withProviderName(instance.getProviderName());
            this.withTunedConfig(instance.getTunedConfig());
            this.withTunedProfile(instance.getTunedProfile());
            this.withVerbosity(instance.getVerbosity());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TunedConfigNested<A> editOrNewTunedConfig() {
        return this.withNewTunedConfigLike(Optional.ofNullable(this.buildTunedConfig()).orElse(new TuneDConfigBuilder().build()));
    }

    public TunedConfigNested<A> editOrNewTunedConfigLike(TuneDConfig item) {
        return this.withNewTunedConfigLike(Optional.ofNullable(this.buildTunedConfig()).orElse(item));
    }

    public TunedConfigNested<A> editTunedConfig() {
        return this.withNewTunedConfigLike(Optional.ofNullable(this.buildTunedConfig()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProfileConfigFluent that = (ProfileConfigFluent)o;
        if (!Objects.equals(this.debug, that.debug)) {
            return false;
        }
        if (!Objects.equals(this.providerName, that.providerName)) {
            return false;
        }
        if (!Objects.equals(this.tunedConfig, that.tunedConfig)) {
            return false;
        }
        if (!Objects.equals(this.tunedProfile, that.tunedProfile)) {
            return false;
        }
        if (!Objects.equals(this.verbosity, that.verbosity)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getTunedProfile() {
        return this.tunedProfile;
    }

    public Integer getVerbosity() {
        return this.verbosity;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDebug() {
        return this.debug != null;
    }

    public boolean hasProviderName() {
        return this.providerName != null;
    }

    public boolean hasTunedConfig() {
        return this.tunedConfig != null;
    }

    public boolean hasTunedProfile() {
        return this.tunedProfile != null;
    }

    public boolean hasVerbosity() {
        return this.verbosity != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.debug, this.providerName, this.tunedConfig, this.tunedProfile, this.verbosity, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.debug != null) {
            sb.append("debug:");
            sb.append(this.debug);
            sb.append(",");
        }
        if (this.providerName != null) {
            sb.append("providerName:");
            sb.append(this.providerName);
            sb.append(",");
        }
        if (this.tunedConfig != null) {
            sb.append("tunedConfig:");
            sb.append(this.tunedConfig);
            sb.append(",");
        }
        if (this.tunedProfile != null) {
            sb.append("tunedProfile:");
            sb.append(this.tunedProfile);
            sb.append(",");
        }
        if (this.verbosity != null) {
            sb.append("verbosity:");
            sb.append(this.verbosity);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withDebug() {
        return this.withDebug(true);
    }

    public A withDebug(Boolean debug) {
        this.debug = debug;
        return (A)this;
    }

    public TunedConfigNested<A> withNewTunedConfig() {
        return new TunedConfigNested(null);
    }

    public A withNewTunedConfig(Boolean reapplySysctl) {
        return this.withTunedConfig(new TuneDConfig(reapplySysctl));
    }

    public TunedConfigNested<A> withNewTunedConfigLike(TuneDConfig item) {
        return new TunedConfigNested(item);
    }

    public A withProviderName(String providerName) {
        this.providerName = providerName;
        return (A)this;
    }

    public A withTunedConfig(TuneDConfig tunedConfig) {
        this._visitables.remove("tunedConfig");
        if (tunedConfig != null) {
            this.tunedConfig = new TuneDConfigBuilder(tunedConfig);
            this._visitables.get("tunedConfig").add(this.tunedConfig);
        } else {
            this.tunedConfig = null;
            this._visitables.get("tunedConfig").remove(this.tunedConfig);
        }
        return (A)this;
    }

    public A withTunedProfile(String tunedProfile) {
        this.tunedProfile = tunedProfile;
        return (A)this;
    }

    public A withVerbosity(Integer verbosity) {
        this.verbosity = verbosity;
        return (A)this;
    }

    public class TunedConfigNested<N>
    extends TuneDConfigFluent<TunedConfigNested<N>>
    implements Nested<N> {
        TuneDConfigBuilder builder;

        TunedConfigNested(TuneDConfig item) {
            this.builder = new TuneDConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProfileConfigFluent.this.withTunedConfig(this.builder.build());
        }

        public N endTunedConfig() {
            return this.and();
        }
    }
}

