/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.ProjectAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProjectAccessFluent<A extends ProjectAccessFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> availableClusterRoles = new ArrayList<String>();

    public ProjectAccessFluent() {
    }

    public ProjectAccessFluent(ProjectAccess instance) {
        this.copyInstance(instance);
    }

    public A addAllToAvailableClusterRoles(Collection<String> items) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        for (String item : items) {
            this.availableClusterRoles.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAvailableClusterRoles(String ... items) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        for (String item : items) {
            this.availableClusterRoles.add(item);
        }
        return (A)this;
    }

    public A addToAvailableClusterRoles(int index, String item) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        this.availableClusterRoles.add(index, item);
        return (A)this;
    }

    protected void copyInstance(ProjectAccess instance) {
        ProjectAccess projectAccess = instance = instance != null ? instance : new ProjectAccess();
        if (instance != null) {
            this.withAvailableClusterRoles(instance.getAvailableClusterRoles());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectAccessFluent that = (ProjectAccessFluent)o;
        if (!Objects.equals(this.availableClusterRoles, that.availableClusterRoles)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAvailableClusterRole(int index) {
        return this.availableClusterRoles.get(index);
    }

    public List<String> getAvailableClusterRoles() {
        return this.availableClusterRoles;
    }

    public String getFirstAvailableClusterRole() {
        return this.availableClusterRoles.get(0);
    }

    public String getLastAvailableClusterRole() {
        return this.availableClusterRoles.get(this.availableClusterRoles.size() - 1);
    }

    public String getMatchingAvailableClusterRole(Predicate<String> predicate) {
        for (String item : this.availableClusterRoles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAvailableClusterRoles() {
        return this.availableClusterRoles != null && !this.availableClusterRoles.isEmpty();
    }

    public boolean hasMatchingAvailableClusterRole(Predicate<String> predicate) {
        for (String item : this.availableClusterRoles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableClusterRoles, this.additionalProperties);
    }

    public A removeAllFromAvailableClusterRoles(Collection<String> items) {
        if (this.availableClusterRoles == null) {
            return (A)this;
        }
        for (String item : items) {
            this.availableClusterRoles.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromAvailableClusterRoles(String ... items) {
        if (this.availableClusterRoles == null) {
            return (A)this;
        }
        for (String item : items) {
            this.availableClusterRoles.remove(item);
        }
        return (A)this;
    }

    public A setToAvailableClusterRoles(int index, String item) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        this.availableClusterRoles.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableClusterRoles != null && !this.availableClusterRoles.isEmpty()) {
            sb.append("availableClusterRoles:");
            sb.append(this.availableClusterRoles);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAvailableClusterRoles(List<String> availableClusterRoles) {
        if (availableClusterRoles != null) {
            this.availableClusterRoles = new ArrayList<String>();
            for (String item : availableClusterRoles) {
                this.addToAvailableClusterRoles(item);
            }
        } else {
            this.availableClusterRoles = null;
        }
        return (A)this;
    }

    public A withAvailableClusterRoles(String ... availableClusterRoles) {
        if (this.availableClusterRoles != null) {
            this.availableClusterRoles.clear();
            this._visitables.remove("availableClusterRoles");
        }
        if (availableClusterRoles != null) {
            for (String item : availableClusterRoles) {
                this.addToAvailableClusterRoles(item);
            }
        }
        return (A)this;
    }
}

