/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategory;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategoryMeta;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategoryMetaBuilder;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategoryMetaFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeveloperConsoleCatalogCategoryFluent<A extends DeveloperConsoleCatalogCategoryFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String id;
    private String label;
    private ArrayList<DeveloperConsoleCatalogCategoryMetaBuilder> subcategories = new ArrayList();
    private List<String> tags = new ArrayList<String>();

    public DeveloperConsoleCatalogCategoryFluent() {
    }

    public DeveloperConsoleCatalogCategoryFluent(DeveloperConsoleCatalogCategory instance) {
        this.copyInstance(instance);
    }

    public A addAllToSubcategories(Collection<DeveloperConsoleCatalogCategoryMeta> items) {
        if (this.subcategories == null) {
            this.subcategories = new ArrayList();
        }
        for (DeveloperConsoleCatalogCategoryMeta item : items) {
            DeveloperConsoleCatalogCategoryMetaBuilder builder = new DeveloperConsoleCatalogCategoryMetaBuilder(item);
            this._visitables.get("subcategories").add(builder);
            this.subcategories.add(builder);
        }
        return (A)this;
    }

    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    public SubcategoriesNested<A> addNewSubcategory() {
        return new SubcategoriesNested(-1, null);
    }

    public SubcategoriesNested<A> addNewSubcategoryLike(DeveloperConsoleCatalogCategoryMeta item) {
        return new SubcategoriesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToSubcategories(DeveloperConsoleCatalogCategoryMeta ... items) {
        if (this.subcategories == null) {
            this.subcategories = new ArrayList();
        }
        for (DeveloperConsoleCatalogCategoryMeta item : items) {
            DeveloperConsoleCatalogCategoryMetaBuilder builder = new DeveloperConsoleCatalogCategoryMetaBuilder(item);
            this._visitables.get("subcategories").add(builder);
            this.subcategories.add(builder);
        }
        return (A)this;
    }

    public A addToSubcategories(int index, DeveloperConsoleCatalogCategoryMeta item) {
        if (this.subcategories == null) {
            this.subcategories = new ArrayList();
        }
        DeveloperConsoleCatalogCategoryMetaBuilder builder = new DeveloperConsoleCatalogCategoryMetaBuilder(item);
        if (index < 0 || index >= this.subcategories.size()) {
            this._visitables.get("subcategories").add(builder);
            this.subcategories.add(builder);
        } else {
            this._visitables.get("subcategories").add(builder);
            this.subcategories.add(index, builder);
        }
        return (A)this;
    }

    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)this;
    }

    public DeveloperConsoleCatalogCategoryMeta buildFirstSubcategory() {
        return this.subcategories.get(0).build();
    }

    public DeveloperConsoleCatalogCategoryMeta buildLastSubcategory() {
        return this.subcategories.get(this.subcategories.size() - 1).build();
    }

    public DeveloperConsoleCatalogCategoryMeta buildMatchingSubcategory(Predicate<DeveloperConsoleCatalogCategoryMetaBuilder> predicate) {
        for (DeveloperConsoleCatalogCategoryMetaBuilder item : this.subcategories) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<DeveloperConsoleCatalogCategoryMeta> buildSubcategories() {
        return this.subcategories != null ? DeveloperConsoleCatalogCategoryFluent.build(this.subcategories) : null;
    }

    public DeveloperConsoleCatalogCategoryMeta buildSubcategory(int index) {
        return this.subcategories.get(index).build();
    }

    protected void copyInstance(DeveloperConsoleCatalogCategory instance) {
        DeveloperConsoleCatalogCategory developerConsoleCatalogCategory = instance = instance != null ? instance : new DeveloperConsoleCatalogCategory();
        if (instance != null) {
            this.withId(instance.getId());
            this.withLabel(instance.getLabel());
            this.withSubcategories(instance.getSubcategories());
            this.withTags(instance.getTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SubcategoriesNested<A> editFirstSubcategory() {
        if (this.subcategories.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "subcategories"));
        }
        return this.setNewSubcategoryLike(0, this.buildSubcategory(0));
    }

    public SubcategoriesNested<A> editLastSubcategory() {
        int index = this.subcategories.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "subcategories"));
        }
        return this.setNewSubcategoryLike(index, this.buildSubcategory(index));
    }

    public SubcategoriesNested<A> editMatchingSubcategory(Predicate<DeveloperConsoleCatalogCategoryMetaBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subcategories.size(); ++i) {
            if (!predicate.test(this.subcategories.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "subcategories"));
        }
        return this.setNewSubcategoryLike(index, this.buildSubcategory(index));
    }

    public SubcategoriesNested<A> editSubcategory(int index) {
        if (this.subcategories.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "subcategories"));
        }
        return this.setNewSubcategoryLike(index, this.buildSubcategory(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeveloperConsoleCatalogCategoryFluent that = (DeveloperConsoleCatalogCategoryFluent)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.label, that.label)) {
            return false;
        }
        if (!Objects.equals(this.subcategories, that.subcategories)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstTag() {
        return this.tags.get(0);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getTag(int index) {
        return this.tags.get(index);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public boolean hasMatchingSubcategory(Predicate<DeveloperConsoleCatalogCategoryMetaBuilder> predicate) {
        for (DeveloperConsoleCatalogCategoryMetaBuilder item : this.subcategories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubcategories() {
        return this.subcategories != null && !this.subcategories.isEmpty();
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.label, this.subcategories, this.tags, this.additionalProperties);
    }

    public A removeAllFromSubcategories(Collection<DeveloperConsoleCatalogCategoryMeta> items) {
        if (this.subcategories == null) {
            return (A)this;
        }
        for (DeveloperConsoleCatalogCategoryMeta item : items) {
            DeveloperConsoleCatalogCategoryMetaBuilder builder = new DeveloperConsoleCatalogCategoryMetaBuilder(item);
            this._visitables.get("subcategories").remove(builder);
            this.subcategories.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTags(Collection<String> items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromSubcategories(DeveloperConsoleCatalogCategoryMeta ... items) {
        if (this.subcategories == null) {
            return (A)this;
        }
        for (DeveloperConsoleCatalogCategoryMeta item : items) {
            DeveloperConsoleCatalogCategoryMetaBuilder builder = new DeveloperConsoleCatalogCategoryMetaBuilder(item);
            this._visitables.get("subcategories").remove(builder);
            this.subcategories.remove(builder);
        }
        return (A)this;
    }

    public A removeFromTags(String ... items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)this;
    }

    public A removeMatchingFromSubcategories(Predicate<DeveloperConsoleCatalogCategoryMetaBuilder> predicate) {
        if (this.subcategories == null) {
            return (A)this;
        }
        Iterator<DeveloperConsoleCatalogCategoryMetaBuilder> each = this.subcategories.iterator();
        Object visitables = this._visitables.get("subcategories");
        while (each.hasNext()) {
            DeveloperConsoleCatalogCategoryMetaBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public SubcategoriesNested<A> setNewSubcategoryLike(int index, DeveloperConsoleCatalogCategoryMeta item) {
        return new SubcategoriesNested(index, item);
    }

    public A setToSubcategories(int index, DeveloperConsoleCatalogCategoryMeta item) {
        if (this.subcategories == null) {
            this.subcategories = new ArrayList();
        }
        DeveloperConsoleCatalogCategoryMetaBuilder builder = new DeveloperConsoleCatalogCategoryMetaBuilder(item);
        if (index < 0 || index >= this.subcategories.size()) {
            this._visitables.get("subcategories").add(builder);
            this.subcategories.add(builder);
        } else {
            this._visitables.get("subcategories").add(builder);
            this.subcategories.set(index, builder);
        }
        return (A)this;
    }

    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id);
            sb.append(",");
        }
        if (this.label != null) {
            sb.append("label:");
            sb.append(this.label);
            sb.append(",");
        }
        if (this.subcategories != null && !this.subcategories.isEmpty()) {
            sb.append("subcategories:");
            sb.append(this.subcategories);
            sb.append(",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    public A withLabel(String label) {
        this.label = label;
        return (A)this;
    }

    public A withSubcategories(List<DeveloperConsoleCatalogCategoryMeta> subcategories) {
        if (this.subcategories != null) {
            this._visitables.get("subcategories").clear();
        }
        if (subcategories != null) {
            this.subcategories = new ArrayList();
            for (DeveloperConsoleCatalogCategoryMeta item : subcategories) {
                this.addToSubcategories(item);
            }
        } else {
            this.subcategories = null;
        }
        return (A)this;
    }

    public A withSubcategories(DeveloperConsoleCatalogCategoryMeta ... subcategories) {
        if (this.subcategories != null) {
            this.subcategories.clear();
            this._visitables.remove("subcategories");
        }
        if (subcategories != null) {
            for (DeveloperConsoleCatalogCategoryMeta item : subcategories) {
                this.addToSubcategories(item);
            }
        }
        return (A)this;
    }

    public A withTags(List<String> tags) {
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove("tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    public class SubcategoriesNested<N>
    extends DeveloperConsoleCatalogCategoryMetaFluent<SubcategoriesNested<N>>
    implements Nested<N> {
        DeveloperConsoleCatalogCategoryMetaBuilder builder;
        int index;

        SubcategoriesNested(int index, DeveloperConsoleCatalogCategoryMeta item) {
            this.index = index;
            this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeveloperConsoleCatalogCategoryFluent.this.setToSubcategories(this.index, this.builder.build());
        }

        public N endSubcategory() {
            return this.and();
        }
    }
}

