/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AWSCSIDriverConfigSpec;
import io.fabric8.openshift.api.model.operator.v1.AWSEFSVolumeMetrics;
import io.fabric8.openshift.api.model.operator.v1.AWSEFSVolumeMetricsBuilder;
import io.fabric8.openshift.api.model.operator.v1.AWSEFSVolumeMetricsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AWSCSIDriverConfigSpecFluent<A extends AWSCSIDriverConfigSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private AWSEFSVolumeMetricsBuilder efsVolumeMetrics;
    private String kmsKeyARN;

    public AWSCSIDriverConfigSpecFluent() {
    }

    public AWSCSIDriverConfigSpecFluent(AWSCSIDriverConfigSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public AWSEFSVolumeMetrics buildEfsVolumeMetrics() {
        return this.efsVolumeMetrics != null ? this.efsVolumeMetrics.build() : null;
    }

    protected void copyInstance(AWSCSIDriverConfigSpec instance) {
        AWSCSIDriverConfigSpec aWSCSIDriverConfigSpec = instance = instance != null ? instance : new AWSCSIDriverConfigSpec();
        if (instance != null) {
            this.withEfsVolumeMetrics(instance.getEfsVolumeMetrics());
            this.withKmsKeyARN(instance.getKmsKeyARN());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public EfsVolumeMetricsNested<A> editEfsVolumeMetrics() {
        return this.withNewEfsVolumeMetricsLike(Optional.ofNullable(this.buildEfsVolumeMetrics()).orElse(null));
    }

    public EfsVolumeMetricsNested<A> editOrNewEfsVolumeMetrics() {
        return this.withNewEfsVolumeMetricsLike(Optional.ofNullable(this.buildEfsVolumeMetrics()).orElse(new AWSEFSVolumeMetricsBuilder().build()));
    }

    public EfsVolumeMetricsNested<A> editOrNewEfsVolumeMetricsLike(AWSEFSVolumeMetrics item) {
        return this.withNewEfsVolumeMetricsLike(Optional.ofNullable(this.buildEfsVolumeMetrics()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSCSIDriverConfigSpecFluent that = (AWSCSIDriverConfigSpecFluent)o;
        if (!Objects.equals(this.efsVolumeMetrics, that.efsVolumeMetrics)) {
            return false;
        }
        if (!Objects.equals(this.kmsKeyARN, that.kmsKeyARN)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getKmsKeyARN() {
        return this.kmsKeyARN;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasEfsVolumeMetrics() {
        return this.efsVolumeMetrics != null;
    }

    public boolean hasKmsKeyARN() {
        return this.kmsKeyARN != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.efsVolumeMetrics, this.kmsKeyARN, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.efsVolumeMetrics != null) {
            sb.append("efsVolumeMetrics:");
            sb.append(this.efsVolumeMetrics);
            sb.append(",");
        }
        if (this.kmsKeyARN != null) {
            sb.append("kmsKeyARN:");
            sb.append(this.kmsKeyARN);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withEfsVolumeMetrics(AWSEFSVolumeMetrics efsVolumeMetrics) {
        this._visitables.remove("efsVolumeMetrics");
        if (efsVolumeMetrics != null) {
            this.efsVolumeMetrics = new AWSEFSVolumeMetricsBuilder(efsVolumeMetrics);
            this._visitables.get("efsVolumeMetrics").add(this.efsVolumeMetrics);
        } else {
            this.efsVolumeMetrics = null;
            this._visitables.get("efsVolumeMetrics").remove(this.efsVolumeMetrics);
        }
        return (A)this;
    }

    public A withKmsKeyARN(String kmsKeyARN) {
        this.kmsKeyARN = kmsKeyARN;
        return (A)this;
    }

    public EfsVolumeMetricsNested<A> withNewEfsVolumeMetrics() {
        return new EfsVolumeMetricsNested(null);
    }

    public EfsVolumeMetricsNested<A> withNewEfsVolumeMetricsLike(AWSEFSVolumeMetrics item) {
        return new EfsVolumeMetricsNested(item);
    }

    public class EfsVolumeMetricsNested<N>
    extends AWSEFSVolumeMetricsFluent<EfsVolumeMetricsNested<N>>
    implements Nested<N> {
        AWSEFSVolumeMetricsBuilder builder;

        EfsVolumeMetricsNested(AWSEFSVolumeMetrics item) {
            this.builder = new AWSEFSVolumeMetricsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSCSIDriverConfigSpecFluent.this.withEfsVolumeMetrics(this.builder.build());
        }

        public N endEfsVolumeMetrics() {
            return this.and();
        }
    }
}

