/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.imageregistry.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigProxy;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigProxyBuilder;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigProxyFluent;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigRequests;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigRequestsBuilder;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigRequestsFluent;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigRoute;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigRouteBuilder;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigRouteFluent;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigStorage;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigStorageBuilder;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigStorageFluent;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistrySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageRegistrySpecFluent<A extends ImageRegistrySpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Affinity affinity;
    private Boolean defaultRoute;
    private Boolean disableRedirect;
    private String httpSecret;
    private String logLevel;
    private Long logging;
    private String managementState;
    private Map<String, String> nodeSelector;
    private Object observedConfig;
    private String operatorLogLevel;
    private ImageRegistryConfigProxyBuilder proxy;
    private Boolean readOnly;
    private Integer replicas;
    private ImageRegistryConfigRequestsBuilder requests;
    private ResourceRequirementsBuilder resources;
    private String rolloutStrategy;
    private ArrayList<ImageRegistryConfigRouteBuilder> routes = new ArrayList();
    private ImageRegistryConfigStorageBuilder storage;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
    private Object unsupportedConfigOverrides;

    public ImageRegistrySpecFluent() {
    }

    public ImageRegistrySpecFluent(ImageRegistrySpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToRoutes(Collection<ImageRegistryConfigRoute> items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (ImageRegistryConfigRoute item : items) {
            ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        }
        return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    public RoutesNested<A> addNewRoute() {
        return new RoutesNested(-1, null);
    }

    public A addNewRoute(String hostname, String name, String secretName) {
        return this.addToRoutes(new ImageRegistryConfigRoute(hostname, name, secretName));
    }

    public RoutesNested<A> addNewRouteLike(ImageRegistryConfigRoute item) {
        return new RoutesNested(-1, item);
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    public A addToRoutes(ImageRegistryConfigRoute ... items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (ImageRegistryConfigRoute item : items) {
            ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        }
        return (A)this;
    }

    public A addToRoutes(int index, ImageRegistryConfigRoute item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
        if (index < 0 || index >= this.routes.size()) {
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        } else {
            this._visitables.get("routes").add(builder);
            this.routes.add(index, builder);
        }
        return (A)this;
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    public ImageRegistryConfigRoute buildFirstRoute() {
        return this.routes.get(0).build();
    }

    public ImageRegistryConfigRoute buildLastRoute() {
        return this.routes.get(this.routes.size() - 1).build();
    }

    public ImageRegistryConfigRoute buildMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
        for (ImageRegistryConfigRouteBuilder item : this.routes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ImageRegistryConfigProxy buildProxy() {
        return this.proxy != null ? this.proxy.build() : null;
    }

    public ImageRegistryConfigRequests buildRequests() {
        return this.requests != null ? this.requests.build() : null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public ImageRegistryConfigRoute buildRoute(int index) {
        return this.routes.get(index).build();
    }

    public List<ImageRegistryConfigRoute> buildRoutes() {
        return this.routes != null ? ImageRegistrySpecFluent.build(this.routes) : null;
    }

    public ImageRegistryConfigStorage buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    protected void copyInstance(ImageRegistrySpec instance) {
        ImageRegistrySpec imageRegistrySpec = instance = instance != null ? instance : new ImageRegistrySpec();
        if (instance != null) {
            this.withAffinity(instance.getAffinity());
            this.withDefaultRoute(instance.getDefaultRoute());
            this.withDisableRedirect(instance.getDisableRedirect());
            this.withHttpSecret(instance.getHttpSecret());
            this.withLogLevel(instance.getLogLevel());
            this.withLogging(instance.getLogging());
            this.withManagementState(instance.getManagementState());
            this.withNodeSelector(instance.getNodeSelector());
            this.withObservedConfig(instance.getObservedConfig());
            this.withOperatorLogLevel(instance.getOperatorLogLevel());
            this.withProxy(instance.getProxy());
            this.withReadOnly(instance.getReadOnly());
            this.withReplicas(instance.getReplicas());
            this.withRequests(instance.getRequests());
            this.withResources(instance.getResources());
            this.withRolloutStrategy(instance.getRolloutStrategy());
            this.withRoutes(instance.getRoutes());
            this.withStorage(instance.getStorage());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RoutesNested<A> editFirstRoute() {
        if (this.routes.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "routes"));
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    public RoutesNested<A> editLastRoute() {
        int index = this.routes.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "routes"));
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public RoutesNested<A> editMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.routes.size(); ++i) {
            if (!predicate.test(this.routes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "routes"));
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public ProxyNested<A> editOrNewProxy() {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(new ImageRegistryConfigProxyBuilder().build()));
    }

    public ProxyNested<A> editOrNewProxyLike(ImageRegistryConfigProxy item) {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(item));
    }

    public RequestsNested<A> editOrNewRequests() {
        return this.withNewRequestsLike(Optional.ofNullable(this.buildRequests()).orElse(new ImageRegistryConfigRequestsBuilder().build()));
    }

    public RequestsNested<A> editOrNewRequestsLike(ImageRegistryConfigRequests item) {
        return this.withNewRequestsLike(Optional.ofNullable(this.buildRequests()).orElse(item));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(new ImageRegistryConfigStorageBuilder().build()));
    }

    public StorageNested<A> editOrNewStorageLike(ImageRegistryConfigStorage item) {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(item));
    }

    public ProxyNested<A> editProxy() {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(null));
    }

    public RequestsNested<A> editRequests() {
        return this.withNewRequestsLike(Optional.ofNullable(this.buildRequests()).orElse(null));
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public RoutesNested<A> editRoute(int index) {
        if (this.routes.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "routes"));
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public StorageNested<A> editStorage() {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageRegistrySpecFluent that = (ImageRegistrySpecFluent)o;
        if (!Objects.equals(this.affinity, that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.defaultRoute, that.defaultRoute)) {
            return false;
        }
        if (!Objects.equals(this.disableRedirect, that.disableRedirect)) {
            return false;
        }
        if (!Objects.equals(this.httpSecret, that.httpSecret)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (!Objects.equals(this.managementState, that.managementState)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.observedConfig, that.observedConfig)) {
            return false;
        }
        if (!Objects.equals(this.operatorLogLevel, that.operatorLogLevel)) {
            return false;
        }
        if (!Objects.equals(this.proxy, that.proxy)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.requests, that.requests)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.rolloutStrategy, that.rolloutStrategy)) {
            return false;
        }
        if (!Objects.equals(this.routes, that.routes)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        if (!Objects.equals(this.unsupportedConfigOverrides, that.unsupportedConfigOverrides)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public Boolean getDefaultRoute() {
        return this.defaultRoute;
    }

    public Boolean getDisableRedirect() {
        return this.disableRedirect;
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    public String getHttpSecret() {
        return this.httpSecret;
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public Long getLogging() {
        return this.logging;
    }

    public String getManagementState() {
        return this.managementState;
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public Object getObservedConfig() {
        return this.observedConfig;
    }

    public String getOperatorLogLevel() {
        return this.operatorLogLevel;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public String getRolloutStrategy() {
        return this.rolloutStrategy;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    public Object getUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAffinity() {
        return this.affinity != null;
    }

    public boolean hasDefaultRoute() {
        return this.defaultRoute != null;
    }

    public boolean hasDisableRedirect() {
        return this.disableRedirect != null;
    }

    public boolean hasHttpSecret() {
        return this.httpSecret != null;
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public boolean hasManagementState() {
        return this.managementState != null;
    }

    public boolean hasMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
        for (ImageRegistryConfigRouteBuilder item : this.routes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public boolean hasObservedConfig() {
        return this.observedConfig != null;
    }

    public boolean hasOperatorLogLevel() {
        return this.operatorLogLevel != null;
    }

    public boolean hasProxy() {
        return this.proxy != null;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public boolean hasRequests() {
        return this.requests != null;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public boolean hasRolloutStrategy() {
        return this.rolloutStrategy != null;
    }

    public boolean hasRoutes() {
        return this.routes != null && !this.routes.isEmpty();
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    public boolean hasUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.affinity, this.defaultRoute, this.disableRedirect, this.httpSecret, this.logLevel, this.logging, this.managementState, this.nodeSelector, this.observedConfig, this.operatorLogLevel, this.proxy, this.readOnly, this.replicas, this.requests, this.resources, this.rolloutStrategy, this.routes, this.storage, this.tolerations, this.topologySpreadConstraints, this.unsupportedConfigOverrides, this.additionalProperties);
    }

    public A removeAllFromRoutes(Collection<ImageRegistryConfigRoute> items) {
        if (this.routes == null) {
            return (A)this;
        }
        for (ImageRegistryConfigRoute item : items) {
            ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
            this._visitables.get("routes").remove(builder);
            this.routes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromRoutes(ImageRegistryConfigRoute ... items) {
        if (this.routes == null) {
            return (A)this;
        }
        for (ImageRegistryConfigRoute item : items) {
            ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
            this._visitables.get("routes").remove(builder);
            this.routes.remove(builder);
        }
        return (A)this;
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    public A removeMatchingFromRoutes(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
        if (this.routes == null) {
            return (A)this;
        }
        Iterator<ImageRegistryConfigRouteBuilder> each = this.routes.iterator();
        Object visitables = this._visitables.get("routes");
        while (each.hasNext()) {
            ImageRegistryConfigRouteBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public RoutesNested<A> setNewRouteLike(int index, ImageRegistryConfigRoute item) {
        return new RoutesNested(index, item);
    }

    public A setToRoutes(int index, ImageRegistryConfigRoute item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
        if (index < 0 || index >= this.routes.size()) {
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        } else {
            this._visitables.get("routes").add(builder);
            this.routes.set(index, builder);
        }
        return (A)this;
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity);
            sb.append(",");
        }
        if (this.defaultRoute != null) {
            sb.append("defaultRoute:");
            sb.append(this.defaultRoute);
            sb.append(",");
        }
        if (this.disableRedirect != null) {
            sb.append("disableRedirect:");
            sb.append(this.disableRedirect);
            sb.append(",");
        }
        if (this.httpSecret != null) {
            sb.append("httpSecret:");
            sb.append(this.httpSecret);
            sb.append(",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel);
            sb.append(",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging);
            sb.append(",");
        }
        if (this.managementState != null) {
            sb.append("managementState:");
            sb.append(this.managementState);
            sb.append(",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector);
            sb.append(",");
        }
        if (this.observedConfig != null) {
            sb.append("observedConfig:");
            sb.append(this.observedConfig);
            sb.append(",");
        }
        if (this.operatorLogLevel != null) {
            sb.append("operatorLogLevel:");
            sb.append(this.operatorLogLevel);
            sb.append(",");
        }
        if (this.proxy != null) {
            sb.append("proxy:");
            sb.append(this.proxy);
            sb.append(",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly);
            sb.append(",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
            sb.append(",");
        }
        if (this.requests != null) {
            sb.append("requests:");
            sb.append(this.requests);
            sb.append(",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources);
            sb.append(",");
        }
        if (this.rolloutStrategy != null) {
            sb.append("rolloutStrategy:");
            sb.append(this.rolloutStrategy);
            sb.append(",");
        }
        if (this.routes != null && !this.routes.isEmpty()) {
            sb.append("routes:");
            sb.append(this.routes);
            sb.append(",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage);
            sb.append(",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations);
            sb.append(",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints);
            sb.append(",");
        }
        if (this.unsupportedConfigOverrides != null) {
            sb.append("unsupportedConfigOverrides:");
            sb.append(this.unsupportedConfigOverrides);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    public A withDefaultRoute() {
        return this.withDefaultRoute(true);
    }

    public A withDefaultRoute(Boolean defaultRoute) {
        this.defaultRoute = defaultRoute;
        return (A)this;
    }

    public A withDisableRedirect() {
        return this.withDisableRedirect(true);
    }

    public A withDisableRedirect(Boolean disableRedirect) {
        this.disableRedirect = disableRedirect;
        return (A)this;
    }

    public A withHttpSecret(String httpSecret) {
        this.httpSecret = httpSecret;
        return (A)this;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    public A withLogging(Long logging) {
        this.logging = logging;
        return (A)this;
    }

    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)this;
    }

    public ProxyNested<A> withNewProxy() {
        return new ProxyNested(null);
    }

    public A withNewProxy(String http, String https, String noProxy) {
        return this.withProxy(new ImageRegistryConfigProxy(http, https, noProxy));
    }

    public ProxyNested<A> withNewProxyLike(ImageRegistryConfigProxy item) {
        return new ProxyNested(item);
    }

    public RequestsNested<A> withNewRequests() {
        return new RequestsNested(null);
    }

    public RequestsNested<A> withNewRequestsLike(ImageRegistryConfigRequests item) {
        return new RequestsNested(item);
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public StorageNested<A> withNewStorage() {
        return new StorageNested(null);
    }

    public StorageNested<A> withNewStorageLike(ImageRegistryConfigStorage item) {
        return new StorageNested(item);
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    public A withObservedConfig(Object observedConfig) {
        this.observedConfig = observedConfig;
        return (A)this;
    }

    public A withOperatorLogLevel(String operatorLogLevel) {
        this.operatorLogLevel = operatorLogLevel;
        return (A)this;
    }

    public A withProxy(ImageRegistryConfigProxy proxy) {
        this._visitables.remove("proxy");
        if (proxy != null) {
            this.proxy = new ImageRegistryConfigProxyBuilder(proxy);
            this._visitables.get("proxy").add(this.proxy);
        } else {
            this.proxy = null;
            this._visitables.get("proxy").remove(this.proxy);
        }
        return (A)this;
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public A withRequests(ImageRegistryConfigRequests requests) {
        this._visitables.remove("requests");
        if (requests != null) {
            this.requests = new ImageRegistryConfigRequestsBuilder(requests);
            this._visitables.get("requests").add(this.requests);
        } else {
            this.requests = null;
            this._visitables.get("requests").remove(this.requests);
        }
        return (A)this;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove("resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public A withRolloutStrategy(String rolloutStrategy) {
        this.rolloutStrategy = rolloutStrategy;
        return (A)this;
    }

    public A withRoutes(List<ImageRegistryConfigRoute> routes) {
        if (this.routes != null) {
            this._visitables.get("routes").clear();
        }
        if (routes != null) {
            this.routes = new ArrayList();
            for (ImageRegistryConfigRoute item : routes) {
                this.addToRoutes(item);
            }
        } else {
            this.routes = null;
        }
        return (A)this;
    }

    public A withRoutes(ImageRegistryConfigRoute ... routes) {
        if (this.routes != null) {
            this.routes.clear();
            this._visitables.remove("routes");
        }
        if (routes != null) {
            for (ImageRegistryConfigRoute item : routes) {
                this.addToRoutes(item);
            }
        }
        return (A)this;
    }

    public A withStorage(ImageRegistryConfigStorage storage) {
        this._visitables.remove("storage");
        if (storage != null) {
            this.storage = new ImageRegistryConfigStorageBuilder(storage);
            this._visitables.get("storage").add(this.storage);
        } else {
            this.storage = null;
            this._visitables.get("storage").remove(this.storage);
        }
        return (A)this;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove("tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove("topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    public A withUnsupportedConfigOverrides(Object unsupportedConfigOverrides) {
        this.unsupportedConfigOverrides = unsupportedConfigOverrides;
        return (A)this;
    }

    public class StorageNested<N>
    extends ImageRegistryConfigStorageFluent<StorageNested<N>>
    implements Nested<N> {
        ImageRegistryConfigStorageBuilder builder;

        StorageNested(ImageRegistryConfigStorage item) {
            this.builder = new ImageRegistryConfigStorageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluent.this.withStorage(this.builder.build());
        }

        public N endStorage() {
            return this.and();
        }
    }

    public class RoutesNested<N>
    extends ImageRegistryConfigRouteFluent<RoutesNested<N>>
    implements Nested<N> {
        ImageRegistryConfigRouteBuilder builder;
        int index;

        RoutesNested(int index, ImageRegistryConfigRoute item) {
            this.index = index;
            this.builder = new ImageRegistryConfigRouteBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluent.this.setToRoutes(this.index, this.builder.build());
        }

        public N endRoute() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class RequestsNested<N>
    extends ImageRegistryConfigRequestsFluent<RequestsNested<N>>
    implements Nested<N> {
        ImageRegistryConfigRequestsBuilder builder;

        RequestsNested(ImageRegistryConfigRequests item) {
            this.builder = new ImageRegistryConfigRequestsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluent.this.withRequests(this.builder.build());
        }

        public N endRequests() {
            return this.and();
        }
    }

    public class ProxyNested<N>
    extends ImageRegistryConfigProxyFluent<ProxyNested<N>>
    implements Nested<N> {
        ImageRegistryConfigProxyBuilder builder;

        ProxyNested(ImageRegistryConfigProxy item) {
            this.builder = new ImageRegistryConfigProxyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluent.this.withProxy(this.builder.build());
        }

        public N endProxy() {
            return this.and();
        }
    }
}

