/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.imageregistry.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigStorageS3;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigStorageS3CloudFront;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigStorageS3CloudFrontBuilder;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigStorageS3CloudFrontFluent;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.S3TrustedCASource;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.S3TrustedCASourceBuilder;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.S3TrustedCASourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImageRegistryConfigStorageS3Fluent<A extends ImageRegistryConfigStorageS3Fluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String bucket;
    private Integer chunkSizeMiB;
    private ImageRegistryConfigStorageS3CloudFrontBuilder cloudFront;
    private Boolean encrypt;
    private String keyID;
    private String region;
    private String regionEndpoint;
    private S3TrustedCASourceBuilder trustedCA;
    private Boolean virtualHostedStyle;

    public ImageRegistryConfigStorageS3Fluent() {
    }

    public ImageRegistryConfigStorageS3Fluent(ImageRegistryConfigStorageS3 instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public ImageRegistryConfigStorageS3CloudFront buildCloudFront() {
        return this.cloudFront != null ? this.cloudFront.build() : null;
    }

    public S3TrustedCASource buildTrustedCA() {
        return this.trustedCA != null ? this.trustedCA.build() : null;
    }

    protected void copyInstance(ImageRegistryConfigStorageS3 instance) {
        ImageRegistryConfigStorageS3 imageRegistryConfigStorageS3 = instance = instance != null ? instance : new ImageRegistryConfigStorageS3();
        if (instance != null) {
            this.withBucket(instance.getBucket());
            this.withChunkSizeMiB(instance.getChunkSizeMiB());
            this.withCloudFront(instance.getCloudFront());
            this.withEncrypt(instance.getEncrypt());
            this.withKeyID(instance.getKeyID());
            this.withRegion(instance.getRegion());
            this.withRegionEndpoint(instance.getRegionEndpoint());
            this.withTrustedCA(instance.getTrustedCA());
            this.withVirtualHostedStyle(instance.getVirtualHostedStyle());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CloudFrontNested<A> editCloudFront() {
        return this.withNewCloudFrontLike(Optional.ofNullable(this.buildCloudFront()).orElse(null));
    }

    public CloudFrontNested<A> editOrNewCloudFront() {
        return this.withNewCloudFrontLike(Optional.ofNullable(this.buildCloudFront()).orElse(new ImageRegistryConfigStorageS3CloudFrontBuilder().build()));
    }

    public CloudFrontNested<A> editOrNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
        return this.withNewCloudFrontLike(Optional.ofNullable(this.buildCloudFront()).orElse(item));
    }

    public TrustedCANested<A> editOrNewTrustedCA() {
        return this.withNewTrustedCALike(Optional.ofNullable(this.buildTrustedCA()).orElse(new S3TrustedCASourceBuilder().build()));
    }

    public TrustedCANested<A> editOrNewTrustedCALike(S3TrustedCASource item) {
        return this.withNewTrustedCALike(Optional.ofNullable(this.buildTrustedCA()).orElse(item));
    }

    public TrustedCANested<A> editTrustedCA() {
        return this.withNewTrustedCALike(Optional.ofNullable(this.buildTrustedCA()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageRegistryConfigStorageS3Fluent that = (ImageRegistryConfigStorageS3Fluent)o;
        if (!Objects.equals(this.bucket, that.bucket)) {
            return false;
        }
        if (!Objects.equals(this.chunkSizeMiB, that.chunkSizeMiB)) {
            return false;
        }
        if (!Objects.equals(this.cloudFront, that.cloudFront)) {
            return false;
        }
        if (!Objects.equals(this.encrypt, that.encrypt)) {
            return false;
        }
        if (!Objects.equals(this.keyID, that.keyID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.regionEndpoint, that.regionEndpoint)) {
            return false;
        }
        if (!Objects.equals(this.trustedCA, that.trustedCA)) {
            return false;
        }
        if (!Objects.equals(this.virtualHostedStyle, that.virtualHostedStyle)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Integer getChunkSizeMiB() {
        return this.chunkSizeMiB;
    }

    public Boolean getEncrypt() {
        return this.encrypt;
    }

    public String getKeyID() {
        return this.keyID;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRegionEndpoint() {
        return this.regionEndpoint;
    }

    public Boolean getVirtualHostedStyle() {
        return this.virtualHostedStyle;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBucket() {
        return this.bucket != null;
    }

    public boolean hasChunkSizeMiB() {
        return this.chunkSizeMiB != null;
    }

    public boolean hasCloudFront() {
        return this.cloudFront != null;
    }

    public boolean hasEncrypt() {
        return this.encrypt != null;
    }

    public boolean hasKeyID() {
        return this.keyID != null;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public boolean hasRegionEndpoint() {
        return this.regionEndpoint != null;
    }

    public boolean hasTrustedCA() {
        return this.trustedCA != null;
    }

    public boolean hasVirtualHostedStyle() {
        return this.virtualHostedStyle != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bucket, this.chunkSizeMiB, this.cloudFront, this.encrypt, this.keyID, this.region, this.regionEndpoint, this.trustedCA, this.virtualHostedStyle, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket != null) {
            sb.append("bucket:");
            sb.append(this.bucket);
            sb.append(",");
        }
        if (this.chunkSizeMiB != null) {
            sb.append("chunkSizeMiB:");
            sb.append(this.chunkSizeMiB);
            sb.append(",");
        }
        if (this.cloudFront != null) {
            sb.append("cloudFront:");
            sb.append(this.cloudFront);
            sb.append(",");
        }
        if (this.encrypt != null) {
            sb.append("encrypt:");
            sb.append(this.encrypt);
            sb.append(",");
        }
        if (this.keyID != null) {
            sb.append("keyID:");
            sb.append(this.keyID);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.regionEndpoint != null) {
            sb.append("regionEndpoint:");
            sb.append(this.regionEndpoint);
            sb.append(",");
        }
        if (this.trustedCA != null) {
            sb.append("trustedCA:");
            sb.append(this.trustedCA);
            sb.append(",");
        }
        if (this.virtualHostedStyle != null) {
            sb.append("virtualHostedStyle:");
            sb.append(this.virtualHostedStyle);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withBucket(String bucket) {
        this.bucket = bucket;
        return (A)this;
    }

    public A withChunkSizeMiB(Integer chunkSizeMiB) {
        this.chunkSizeMiB = chunkSizeMiB;
        return (A)this;
    }

    public A withCloudFront(ImageRegistryConfigStorageS3CloudFront cloudFront) {
        this._visitables.remove("cloudFront");
        if (cloudFront != null) {
            this.cloudFront = new ImageRegistryConfigStorageS3CloudFrontBuilder(cloudFront);
            this._visitables.get("cloudFront").add(this.cloudFront);
        } else {
            this.cloudFront = null;
            this._visitables.get("cloudFront").remove(this.cloudFront);
        }
        return (A)this;
    }

    public A withEncrypt() {
        return this.withEncrypt(true);
    }

    public A withEncrypt(Boolean encrypt) {
        this.encrypt = encrypt;
        return (A)this;
    }

    public A withKeyID(String keyID) {
        this.keyID = keyID;
        return (A)this;
    }

    public CloudFrontNested<A> withNewCloudFront() {
        return new CloudFrontNested(null);
    }

    public CloudFrontNested<A> withNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
        return new CloudFrontNested(item);
    }

    public TrustedCANested<A> withNewTrustedCA() {
        return new TrustedCANested(null);
    }

    public A withNewTrustedCA(String name) {
        return this.withTrustedCA(new S3TrustedCASource(name));
    }

    public TrustedCANested<A> withNewTrustedCALike(S3TrustedCASource item) {
        return new TrustedCANested(item);
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public A withRegionEndpoint(String regionEndpoint) {
        this.regionEndpoint = regionEndpoint;
        return (A)this;
    }

    public A withTrustedCA(S3TrustedCASource trustedCA) {
        this._visitables.remove("trustedCA");
        if (trustedCA != null) {
            this.trustedCA = new S3TrustedCASourceBuilder(trustedCA);
            this._visitables.get("trustedCA").add(this.trustedCA);
        } else {
            this.trustedCA = null;
            this._visitables.get("trustedCA").remove(this.trustedCA);
        }
        return (A)this;
    }

    public A withVirtualHostedStyle() {
        return this.withVirtualHostedStyle(true);
    }

    public A withVirtualHostedStyle(Boolean virtualHostedStyle) {
        this.virtualHostedStyle = virtualHostedStyle;
        return (A)this;
    }

    public class TrustedCANested<N>
    extends S3TrustedCASourceFluent<TrustedCANested<N>>
    implements Nested<N> {
        S3TrustedCASourceBuilder builder;

        TrustedCANested(S3TrustedCASource item) {
            this.builder = new S3TrustedCASourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistryConfigStorageS3Fluent.this.withTrustedCA(this.builder.build());
        }

        public N endTrustedCA() {
            return this.and();
        }
    }

    public class CloudFrontNested<N>
    extends ImageRegistryConfigStorageS3CloudFrontFluent<CloudFrontNested<N>>
    implements Nested<N> {
        ImageRegistryConfigStorageS3CloudFrontBuilder builder;

        CloudFrontNested(ImageRegistryConfigStorageS3CloudFront item) {
            this.builder = new ImageRegistryConfigStorageS3CloudFrontBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistryConfigStorageS3Fluent.this.withCloudFront(this.builder.build());
        }

        public N endCloudFront() {
            return this.and();
        }
    }
}

