/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PodNetworkConnectivityCheckSpecFluent<A extends PodNetworkConnectivityCheckSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String sourcePod;
    private String targetEndpoint;
    private SecretNameReference tlsClientCert;

    public PodNetworkConnectivityCheckSpecFluent() {
    }

    public PodNetworkConnectivityCheckSpecFluent(PodNetworkConnectivityCheckSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    protected void copyInstance(PodNetworkConnectivityCheckSpec instance) {
        PodNetworkConnectivityCheckSpec podNetworkConnectivityCheckSpec = instance = instance != null ? instance : new PodNetworkConnectivityCheckSpec();
        if (instance != null) {
            this.withSourcePod(instance.getSourcePod());
            this.withTargetEndpoint(instance.getTargetEndpoint());
            this.withTlsClientCert(instance.getTlsClientCert());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodNetworkConnectivityCheckSpecFluent that = (PodNetworkConnectivityCheckSpecFluent)o;
        if (!Objects.equals(this.sourcePod, that.sourcePod)) {
            return false;
        }
        if (!Objects.equals(this.targetEndpoint, that.targetEndpoint)) {
            return false;
        }
        if (!Objects.equals(this.tlsClientCert, that.tlsClientCert)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getSourcePod() {
        return this.sourcePod;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public SecretNameReference getTlsClientCert() {
        return this.tlsClientCert;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasSourcePod() {
        return this.sourcePod != null;
    }

    public boolean hasTargetEndpoint() {
        return this.targetEndpoint != null;
    }

    public boolean hasTlsClientCert() {
        return this.tlsClientCert != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sourcePod, this.targetEndpoint, this.tlsClientCert, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourcePod != null) {
            sb.append("sourcePod:");
            sb.append(this.sourcePod);
            sb.append(",");
        }
        if (this.targetEndpoint != null) {
            sb.append("targetEndpoint:");
            sb.append(this.targetEndpoint);
            sb.append(",");
        }
        if (this.tlsClientCert != null) {
            sb.append("tlsClientCert:");
            sb.append(this.tlsClientCert);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withNewTlsClientCert(String name) {
        return this.withTlsClientCert(new SecretNameReference(name));
    }

    public A withSourcePod(String sourcePod) {
        this.sourcePod = sourcePod;
        return (A)this;
    }

    public A withTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
        return (A)this;
    }

    public A withTlsClientCert(SecretNameReference tlsClientCert) {
        this.tlsClientCert = tlsClientCert;
        return (A)this;
    }
}

