/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.RocketChatActionConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.RocketChatActionConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.RocketChatActionConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.RocketChatConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.RocketChatFieldConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.RocketChatFieldConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.RocketChatFieldConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RocketChatConfigFluent<A extends RocketChatConfigFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RocketChatActionConfigBuilder> actions = new ArrayList();
    private Map<String, Object> additionalProperties;
    private String apiURL;
    private String channel;
    private String color;
    private String emoji;
    private ArrayList<RocketChatFieldConfigBuilder> fields = new ArrayList();
    private HTTPConfigBuilder httpConfig;
    private String iconURL;
    private String imageURL;
    private Boolean linkNames;
    private Boolean sendResolved;
    private Boolean shortFields;
    private String text;
    private String thumbURL;
    private String title;
    private String titleLink;
    private SecretKeySelector token;
    private SecretKeySelector tokenID;

    public RocketChatConfigFluent() {
    }

    public RocketChatConfigFluent(RocketChatConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToActions(Collection<RocketChatActionConfig> items) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        for (RocketChatActionConfig item : items) {
            RocketChatActionConfigBuilder builder = new RocketChatActionConfigBuilder(item);
            this._visitables.get("actions").add(builder);
            this.actions.add(builder);
        }
        return (A)this;
    }

    public A addAllToFields(Collection<RocketChatFieldConfig> items) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        for (RocketChatFieldConfig item : items) {
            RocketChatFieldConfigBuilder builder = new RocketChatFieldConfigBuilder(item);
            this._visitables.get("fields").add(builder);
            this.fields.add(builder);
        }
        return (A)this;
    }

    public ActionsNested<A> addNewAction() {
        return new ActionsNested(-1, null);
    }

    public A addNewAction(String msg, String text, String url) {
        return this.addToActions(new RocketChatActionConfig(msg, text, url));
    }

    public ActionsNested<A> addNewActionLike(RocketChatActionConfig item) {
        return new ActionsNested(-1, item);
    }

    public FieldsNested<A> addNewField() {
        return new FieldsNested(-1, null);
    }

    public A addNewField(Boolean _short, String title, String value) {
        return this.addToFields(new RocketChatFieldConfig(_short, title, value));
    }

    public FieldsNested<A> addNewFieldLike(RocketChatFieldConfig item) {
        return new FieldsNested(-1, item);
    }

    public A addToActions(RocketChatActionConfig ... items) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        for (RocketChatActionConfig item : items) {
            RocketChatActionConfigBuilder builder = new RocketChatActionConfigBuilder(item);
            this._visitables.get("actions").add(builder);
            this.actions.add(builder);
        }
        return (A)this;
    }

    public A addToActions(int index, RocketChatActionConfig item) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        RocketChatActionConfigBuilder builder = new RocketChatActionConfigBuilder(item);
        if (index < 0 || index >= this.actions.size()) {
            this._visitables.get("actions").add(builder);
            this.actions.add(builder);
        } else {
            this._visitables.get("actions").add(builder);
            this.actions.add(index, builder);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToFields(RocketChatFieldConfig ... items) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        for (RocketChatFieldConfig item : items) {
            RocketChatFieldConfigBuilder builder = new RocketChatFieldConfigBuilder(item);
            this._visitables.get("fields").add(builder);
            this.fields.add(builder);
        }
        return (A)this;
    }

    public A addToFields(int index, RocketChatFieldConfig item) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        RocketChatFieldConfigBuilder builder = new RocketChatFieldConfigBuilder(item);
        if (index < 0 || index >= this.fields.size()) {
            this._visitables.get("fields").add(builder);
            this.fields.add(builder);
        } else {
            this._visitables.get("fields").add(builder);
            this.fields.add(index, builder);
        }
        return (A)this;
    }

    public RocketChatActionConfig buildAction(int index) {
        return this.actions.get(index).build();
    }

    public List<RocketChatActionConfig> buildActions() {
        return this.actions != null ? RocketChatConfigFluent.build(this.actions) : null;
    }

    public RocketChatFieldConfig buildField(int index) {
        return this.fields.get(index).build();
    }

    public List<RocketChatFieldConfig> buildFields() {
        return this.fields != null ? RocketChatConfigFluent.build(this.fields) : null;
    }

    public RocketChatActionConfig buildFirstAction() {
        return this.actions.get(0).build();
    }

    public RocketChatFieldConfig buildFirstField() {
        return this.fields.get(0).build();
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public RocketChatActionConfig buildLastAction() {
        return this.actions.get(this.actions.size() - 1).build();
    }

    public RocketChatFieldConfig buildLastField() {
        return this.fields.get(this.fields.size() - 1).build();
    }

    public RocketChatActionConfig buildMatchingAction(Predicate<RocketChatActionConfigBuilder> predicate) {
        for (RocketChatActionConfigBuilder item : this.actions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public RocketChatFieldConfig buildMatchingField(Predicate<RocketChatFieldConfigBuilder> predicate) {
        for (RocketChatFieldConfigBuilder item : this.fields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(RocketChatConfig instance) {
        RocketChatConfig rocketChatConfig = instance = instance != null ? instance : new RocketChatConfig();
        if (instance != null) {
            this.withActions(instance.getActions());
            this.withApiURL(instance.getApiURL());
            this.withChannel(instance.getChannel());
            this.withColor(instance.getColor());
            this.withEmoji(instance.getEmoji());
            this.withFields(instance.getFields());
            this.withHttpConfig(instance.getHttpConfig());
            this.withIconURL(instance.getIconURL());
            this.withImageURL(instance.getImageURL());
            this.withLinkNames(instance.getLinkNames());
            this.withSendResolved(instance.getSendResolved());
            this.withShortFields(instance.getShortFields());
            this.withText(instance.getText());
            this.withThumbURL(instance.getThumbURL());
            this.withTitle(instance.getTitle());
            this.withTitleLink(instance.getTitleLink());
            this.withToken(instance.getToken());
            this.withTokenID(instance.getTokenID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ActionsNested<A> editAction(int index) {
        if (this.actions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "actions"));
        }
        return this.setNewActionLike(index, this.buildAction(index));
    }

    public FieldsNested<A> editField(int index) {
        if (this.fields.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "fields"));
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    public ActionsNested<A> editFirstAction() {
        if (this.actions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "actions"));
        }
        return this.setNewActionLike(0, this.buildAction(0));
    }

    public FieldsNested<A> editFirstField() {
        if (this.fields.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "fields"));
        }
        return this.setNewFieldLike(0, this.buildField(0));
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public ActionsNested<A> editLastAction() {
        int index = this.actions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "actions"));
        }
        return this.setNewActionLike(index, this.buildAction(index));
    }

    public FieldsNested<A> editLastField() {
        int index = this.fields.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "fields"));
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    public ActionsNested<A> editMatchingAction(Predicate<RocketChatActionConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.actions.size(); ++i) {
            if (!predicate.test(this.actions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "actions"));
        }
        return this.setNewActionLike(index, this.buildAction(index));
    }

    public FieldsNested<A> editMatchingField(Predicate<RocketChatFieldConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!predicate.test(this.fields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "fields"));
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RocketChatConfigFluent that = (RocketChatConfigFluent)o;
        if (!Objects.equals(this.actions, that.actions)) {
            return false;
        }
        if (!Objects.equals(this.apiURL, that.apiURL)) {
            return false;
        }
        if (!Objects.equals(this.channel, that.channel)) {
            return false;
        }
        if (!Objects.equals(this.color, that.color)) {
            return false;
        }
        if (!Objects.equals(this.emoji, that.emoji)) {
            return false;
        }
        if (!Objects.equals(this.fields, that.fields)) {
            return false;
        }
        if (!Objects.equals(this.httpConfig, that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.iconURL, that.iconURL)) {
            return false;
        }
        if (!Objects.equals(this.imageURL, that.imageURL)) {
            return false;
        }
        if (!Objects.equals(this.linkNames, that.linkNames)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.shortFields, that.shortFields)) {
            return false;
        }
        if (!Objects.equals(this.text, that.text)) {
            return false;
        }
        if (!Objects.equals(this.thumbURL, that.thumbURL)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        if (!Objects.equals(this.titleLink, that.titleLink)) {
            return false;
        }
        if (!Objects.equals(this.token, that.token)) {
            return false;
        }
        if (!Objects.equals(this.tokenID, that.tokenID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getColor() {
        return this.color;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public Boolean getLinkNames() {
        return this.linkNames;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public Boolean getShortFields() {
        return this.shortFields;
    }

    public String getText() {
        return this.text;
    }

    public String getThumbURL() {
        return this.thumbURL;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleLink() {
        return this.titleLink;
    }

    public SecretKeySelector getToken() {
        return this.token;
    }

    public SecretKeySelector getTokenID() {
        return this.tokenID;
    }

    public boolean hasActions() {
        return this.actions != null && !this.actions.isEmpty();
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiURL() {
        return this.apiURL != null;
    }

    public boolean hasChannel() {
        return this.channel != null;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public boolean hasEmoji() {
        return this.emoji != null;
    }

    public boolean hasFields() {
        return this.fields != null && !this.fields.isEmpty();
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public boolean hasIconURL() {
        return this.iconURL != null;
    }

    public boolean hasImageURL() {
        return this.imageURL != null;
    }

    public boolean hasLinkNames() {
        return this.linkNames != null;
    }

    public boolean hasMatchingAction(Predicate<RocketChatActionConfigBuilder> predicate) {
        for (RocketChatActionConfigBuilder item : this.actions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingField(Predicate<RocketChatFieldConfigBuilder> predicate) {
        for (RocketChatFieldConfigBuilder item : this.fields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public boolean hasShortFields() {
        return this.shortFields != null;
    }

    public boolean hasText() {
        return this.text != null;
    }

    public boolean hasThumbURL() {
        return this.thumbURL != null;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public boolean hasTitleLink() {
        return this.titleLink != null;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public boolean hasTokenID() {
        return this.tokenID != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.actions, this.apiURL, this.channel, this.color, this.emoji, this.fields, this.httpConfig, this.iconURL, this.imageURL, this.linkNames, this.sendResolved, this.shortFields, this.text, this.thumbURL, this.title, this.titleLink, this.token, this.tokenID, this.additionalProperties);
    }

    public A removeAllFromActions(Collection<RocketChatActionConfig> items) {
        if (this.actions == null) {
            return (A)this;
        }
        for (RocketChatActionConfig item : items) {
            RocketChatActionConfigBuilder builder = new RocketChatActionConfigBuilder(item);
            this._visitables.get("actions").remove(builder);
            this.actions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFields(Collection<RocketChatFieldConfig> items) {
        if (this.fields == null) {
            return (A)this;
        }
        for (RocketChatFieldConfig item : items) {
            RocketChatFieldConfigBuilder builder = new RocketChatFieldConfigBuilder(item);
            this._visitables.get("fields").remove(builder);
            this.fields.remove(builder);
        }
        return (A)this;
    }

    public A removeFromActions(RocketChatActionConfig ... items) {
        if (this.actions == null) {
            return (A)this;
        }
        for (RocketChatActionConfig item : items) {
            RocketChatActionConfigBuilder builder = new RocketChatActionConfigBuilder(item);
            this._visitables.get("actions").remove(builder);
            this.actions.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromFields(RocketChatFieldConfig ... items) {
        if (this.fields == null) {
            return (A)this;
        }
        for (RocketChatFieldConfig item : items) {
            RocketChatFieldConfigBuilder builder = new RocketChatFieldConfigBuilder(item);
            this._visitables.get("fields").remove(builder);
            this.fields.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromActions(Predicate<RocketChatActionConfigBuilder> predicate) {
        if (this.actions == null) {
            return (A)this;
        }
        Iterator<RocketChatActionConfigBuilder> each = this.actions.iterator();
        Object visitables = this._visitables.get("actions");
        while (each.hasNext()) {
            RocketChatActionConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromFields(Predicate<RocketChatFieldConfigBuilder> predicate) {
        if (this.fields == null) {
            return (A)this;
        }
        Iterator<RocketChatFieldConfigBuilder> each = this.fields.iterator();
        Object visitables = this._visitables.get("fields");
        while (each.hasNext()) {
            RocketChatFieldConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ActionsNested<A> setNewActionLike(int index, RocketChatActionConfig item) {
        return new ActionsNested(index, item);
    }

    public FieldsNested<A> setNewFieldLike(int index, RocketChatFieldConfig item) {
        return new FieldsNested(index, item);
    }

    public A setToActions(int index, RocketChatActionConfig item) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        RocketChatActionConfigBuilder builder = new RocketChatActionConfigBuilder(item);
        if (index < 0 || index >= this.actions.size()) {
            this._visitables.get("actions").add(builder);
            this.actions.add(builder);
        } else {
            this._visitables.get("actions").add(builder);
            this.actions.set(index, builder);
        }
        return (A)this;
    }

    public A setToFields(int index, RocketChatFieldConfig item) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        RocketChatFieldConfigBuilder builder = new RocketChatFieldConfigBuilder(item);
        if (index < 0 || index >= this.fields.size()) {
            this._visitables.get("fields").add(builder);
            this.fields.add(builder);
        } else {
            this._visitables.get("fields").add(builder);
            this.fields.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actions != null && !this.actions.isEmpty()) {
            sb.append("actions:");
            sb.append(this.actions);
            sb.append(",");
        }
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(this.apiURL);
            sb.append(",");
        }
        if (this.channel != null) {
            sb.append("channel:");
            sb.append(this.channel);
            sb.append(",");
        }
        if (this.color != null) {
            sb.append("color:");
            sb.append(this.color);
            sb.append(",");
        }
        if (this.emoji != null) {
            sb.append("emoji:");
            sb.append(this.emoji);
            sb.append(",");
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            sb.append("fields:");
            sb.append(this.fields);
            sb.append(",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(this.httpConfig);
            sb.append(",");
        }
        if (this.iconURL != null) {
            sb.append("iconURL:");
            sb.append(this.iconURL);
            sb.append(",");
        }
        if (this.imageURL != null) {
            sb.append("imageURL:");
            sb.append(this.imageURL);
            sb.append(",");
        }
        if (this.linkNames != null) {
            sb.append("linkNames:");
            sb.append(this.linkNames);
            sb.append(",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved);
            sb.append(",");
        }
        if (this.shortFields != null) {
            sb.append("shortFields:");
            sb.append(this.shortFields);
            sb.append(",");
        }
        if (this.text != null) {
            sb.append("text:");
            sb.append(this.text);
            sb.append(",");
        }
        if (this.thumbURL != null) {
            sb.append("thumbURL:");
            sb.append(this.thumbURL);
            sb.append(",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title);
            sb.append(",");
        }
        if (this.titleLink != null) {
            sb.append("titleLink:");
            sb.append(this.titleLink);
            sb.append(",");
        }
        if (this.token != null) {
            sb.append("token:");
            sb.append(this.token);
            sb.append(",");
        }
        if (this.tokenID != null) {
            sb.append("tokenID:");
            sb.append(this.tokenID);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withActions(List<RocketChatActionConfig> actions) {
        if (this.actions != null) {
            this._visitables.get("actions").clear();
        }
        if (actions != null) {
            this.actions = new ArrayList();
            for (RocketChatActionConfig item : actions) {
                this.addToActions(item);
            }
        } else {
            this.actions = null;
        }
        return (A)this;
    }

    public A withActions(RocketChatActionConfig ... actions) {
        if (this.actions != null) {
            this.actions.clear();
            this._visitables.remove("actions");
        }
        if (actions != null) {
            for (RocketChatActionConfig item : actions) {
                this.addToActions(item);
            }
        }
        return (A)this;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withApiURL(String apiURL) {
        this.apiURL = apiURL;
        return (A)this;
    }

    public A withChannel(String channel) {
        this.channel = channel;
        return (A)this;
    }

    public A withColor(String color) {
        this.color = color;
        return (A)this;
    }

    public A withEmoji(String emoji) {
        this.emoji = emoji;
        return (A)this;
    }

    public A withFields(List<RocketChatFieldConfig> fields) {
        if (this.fields != null) {
            this._visitables.get("fields").clear();
        }
        if (fields != null) {
            this.fields = new ArrayList();
            for (RocketChatFieldConfig item : fields) {
                this.addToFields(item);
            }
        } else {
            this.fields = null;
        }
        return (A)this;
    }

    public A withFields(RocketChatFieldConfig ... fields) {
        if (this.fields != null) {
            this.fields.clear();
            this._visitables.remove("fields");
        }
        if (fields != null) {
            for (RocketChatFieldConfig item : fields) {
                this.addToFields(item);
            }
        }
        return (A)this;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove("httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    public A withIconURL(String iconURL) {
        this.iconURL = iconURL;
        return (A)this;
    }

    public A withImageURL(String imageURL) {
        this.imageURL = imageURL;
        return (A)this;
    }

    public A withLinkNames() {
        return this.withLinkNames(true);
    }

    public A withLinkNames(Boolean linkNames) {
        this.linkNames = linkNames;
        return (A)this;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public A withNewToken(String key, String name, Boolean optional) {
        return this.withToken(new SecretKeySelector(key, name, optional));
    }

    public A withNewTokenID(String key, String name, Boolean optional) {
        return this.withTokenID(new SecretKeySelector(key, name, optional));
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    public A withShortFields() {
        return this.withShortFields(true);
    }

    public A withShortFields(Boolean shortFields) {
        this.shortFields = shortFields;
        return (A)this;
    }

    public A withText(String text) {
        this.text = text;
        return (A)this;
    }

    public A withThumbURL(String thumbURL) {
        this.thumbURL = thumbURL;
        return (A)this;
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)this;
    }

    public A withTitleLink(String titleLink) {
        this.titleLink = titleLink;
        return (A)this;
    }

    public A withToken(SecretKeySelector token) {
        this.token = token;
        return (A)this;
    }

    public A withTokenID(SecretKeySelector tokenID) {
        this.tokenID = tokenID;
        return (A)this;
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RocketChatConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }

    public class FieldsNested<N>
    extends RocketChatFieldConfigFluent<FieldsNested<N>>
    implements Nested<N> {
        RocketChatFieldConfigBuilder builder;
        int index;

        FieldsNested(int index, RocketChatFieldConfig item) {
            this.index = index;
            this.builder = new RocketChatFieldConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RocketChatConfigFluent.this.setToFields(this.index, this.builder.build());
        }

        public N endField() {
            return this.and();
        }
    }

    public class ActionsNested<N>
    extends RocketChatActionConfigFluent<ActionsNested<N>>
    implements Nested<N> {
        RocketChatActionConfigBuilder builder;
        int index;

        ActionsNested(int index, RocketChatActionConfig item) {
            this.index = index;
            this.builder = new RocketChatActionConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RocketChatConfigFluent.this.setToActions(this.index, this.builder.build());
        }

        public N endAction() {
            return this.and();
        }
    }
}

