/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.Authorization;
import io.fabric8.openshift.api.model.monitoring.v1.AuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RemoteReadSpecFluent<A extends RemoteReadSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private AuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private String bearerToken;
    private String bearerTokenFile;
    private Boolean filterExternalLabels;
    private Boolean followRedirects;
    private Map<String, String> headers;
    private String name;
    private String noProxy;
    private OAuth2Builder oauth2;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyUrl;
    private Boolean readRecent;
    private String remoteTimeout;
    private Map<String, String> requiredMatchers;
    private TLSConfigBuilder tlsConfig;
    private String url;

    public RemoteReadSpecFluent() {
    }

    public RemoteReadSpecFluent(RemoteReadSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToHeaders(Map<String, String> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)this;
    }

    public A addToHeaders(String key, String value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)this;
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)this;
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)this;
    }

    public A addToRequiredMatchers(Map<String, String> map) {
        if (this.requiredMatchers == null && map != null) {
            this.requiredMatchers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.requiredMatchers.putAll(map);
        }
        return (A)this;
    }

    public A addToRequiredMatchers(String key, String value) {
        if (this.requiredMatchers == null && key != null && value != null) {
            this.requiredMatchers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.requiredMatchers.put(key, value);
        }
        return (A)this;
    }

    public Authorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    protected void copyInstance(RemoteReadSpec instance) {
        RemoteReadSpec remoteReadSpec = instance = instance != null ? instance : new RemoteReadSpec();
        if (instance != null) {
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withBearerToken(instance.getBearerToken());
            this.withBearerTokenFile(instance.getBearerTokenFile());
            this.withFilterExternalLabels(instance.getFilterExternalLabels());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withHeaders(instance.getHeaders());
            this.withName(instance.getName());
            this.withNoProxy(instance.getNoProxy());
            this.withOauth2(instance.getOauth2());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyUrl(instance.getProxyUrl());
            this.withReadRecent(instance.getReadRecent());
            this.withRemoteTimeout(instance.getRemoteTimeout());
            this.withRequiredMatchers(instance.getRequiredMatchers());
            this.withTlsConfig(instance.getTlsConfig());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new AuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(new OAuth2Builder().build()));
    }

    public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(item));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoteReadSpecFluent that = (RemoteReadSpecFluent)o;
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.basicAuth, that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.bearerToken, that.bearerToken)) {
            return false;
        }
        if (!Objects.equals(this.bearerTokenFile, that.bearerTokenFile)) {
            return false;
        }
        if (!Objects.equals(this.filterExternalLabels, that.filterExternalLabels)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.oauth2, that.oauth2)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.readRecent, that.readRecent)) {
            return false;
        }
        if (!Objects.equals(this.remoteTimeout, that.remoteTimeout)) {
            return false;
        }
        if (!Objects.equals(this.requiredMatchers, that.requiredMatchers)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public Boolean getFilterExternalLabels() {
        return this.filterExternalLabels;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getName() {
        return this.name;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public Boolean getReadRecent() {
        return this.readRecent;
    }

    public String getRemoteTimeout() {
        return this.remoteTimeout;
    }

    public Map<String, String> getRequiredMatchers() {
        return this.requiredMatchers;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public boolean hasBearerToken() {
        return this.bearerToken != null;
    }

    public boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    public boolean hasFilterExternalLabels() {
        return this.filterExternalLabels != null;
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public boolean hasOauth2() {
        return this.oauth2 != null;
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public boolean hasReadRecent() {
        return this.readRecent != null;
    }

    public boolean hasRemoteTimeout() {
        return this.remoteTimeout != null;
    }

    public boolean hasRequiredMatchers() {
        return this.requiredMatchers != null;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authorization, this.basicAuth, this.bearerToken, this.bearerTokenFile, this.filterExternalLabels, this.followRedirects, this.headers, this.name, this.noProxy, this.oauth2, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyUrl, this.readRecent, this.remoteTimeout, this.requiredMatchers, this.tlsConfig, this.url, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)this;
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)this;
    }

    public A removeFromHeaders(Map<String, String> map) {
        if (this.headers == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromRequiredMatchers(String key) {
        if (this.requiredMatchers == null) {
            return (A)this;
        }
        if (key != null && this.requiredMatchers != null) {
            this.requiredMatchers.remove(key);
        }
        return (A)this;
    }

    public A removeFromRequiredMatchers(Map<String, String> map) {
        if (this.requiredMatchers == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requiredMatchers == null) continue;
                this.requiredMatchers.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization);
            sb.append(",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(this.basicAuth);
            sb.append(",");
        }
        if (this.bearerToken != null) {
            sb.append("bearerToken:");
            sb.append(this.bearerToken);
            sb.append(",");
        }
        if (this.bearerTokenFile != null) {
            sb.append("bearerTokenFile:");
            sb.append(this.bearerTokenFile);
            sb.append(",");
        }
        if (this.filterExternalLabels != null) {
            sb.append("filterExternalLabels:");
            sb.append(this.filterExternalLabels);
            sb.append(",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects);
            sb.append(",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy);
            sb.append(",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append(this.oauth2);
            sb.append(",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(this.proxyConnectHeader);
            sb.append(",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment);
            sb.append(",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl);
            sb.append(",");
        }
        if (this.readRecent != null) {
            sb.append("readRecent:");
            sb.append(this.readRecent);
            sb.append(",");
        }
        if (this.remoteTimeout != null) {
            sb.append("remoteTimeout:");
            sb.append(this.remoteTimeout);
            sb.append(",");
        }
        if (this.requiredMatchers != null && !this.requiredMatchers.isEmpty()) {
            sb.append("requiredMatchers:");
            sb.append(this.requiredMatchers);
            sb.append(",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig);
            sb.append(",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAuthorization(Authorization authorization) {
        this._visitables.remove("authorization");
        if (authorization != null) {
            this.authorization = new AuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove("basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get("basicAuth").remove(this.basicAuth);
        }
        return (A)this;
    }

    public A withBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return (A)this;
    }

    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return (A)this;
    }

    public A withFilterExternalLabels() {
        return this.withFilterExternalLabels(true);
    }

    public A withFilterExternalLabels(Boolean filterExternalLabels) {
        this.filterExternalLabels = filterExternalLabels;
        return (A)this;
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)this;
    }

    public <K, V> A withHeaders(Map<String, String> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, String>(headers);
        return (A)this;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
        return new AuthorizationNested(item);
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public Oauth2Nested<A> withNewOauth2() {
        return new Oauth2Nested(null);
    }

    public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2Nested(item);
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNested(item);
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    public A withOauth2(OAuth2 oauth2) {
        this._visitables.remove("oauth2");
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get("oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get("oauth2").remove(this.oauth2);
        }
        return (A)this;
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)this;
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)this;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    public A withReadRecent() {
        return this.withReadRecent(true);
    }

    public A withReadRecent(Boolean readRecent) {
        this.readRecent = readRecent;
        return (A)this;
    }

    public A withRemoteTimeout(String remoteTimeout) {
        this.remoteTimeout = remoteTimeout;
        return (A)this;
    }

    public <K, V> A withRequiredMatchers(Map<String, String> requiredMatchers) {
        this.requiredMatchers = requiredMatchers == null ? null : new LinkedHashMap<String, String>(requiredMatchers);
        return (A)this;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    public class TlsConfigNested<N>
    extends TLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteReadSpecFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class Oauth2Nested<N>
    extends OAuth2Fluent<Oauth2Nested<N>>
    implements Nested<N> {
        OAuth2Builder builder;

        Oauth2Nested(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteReadSpecFluent.this.withOauth2(this.builder.build());
        }

        public N endOauth2() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteReadSpecFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends AuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        AuthorizationBuilder builder;

        AuthorizationNested(Authorization item) {
            this.builder = new AuthorizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteReadSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

