/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.monitoring.v1.PrometheusTracingConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PrometheusTracingConfigFluent<A extends PrometheusTracingConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String clientType;
    private String compression;
    private String endpoint;
    private Map<String, String> headers;
    private Boolean insecure;
    private Quantity samplingFraction;
    private String timeout;
    private TLSConfigBuilder tlsConfig;

    public PrometheusTracingConfigFluent() {
    }

    public PrometheusTracingConfigFluent(PrometheusTracingConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToHeaders(Map<String, String> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)this;
    }

    public A addToHeaders(String key, String value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)this;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    protected void copyInstance(PrometheusTracingConfig instance) {
        PrometheusTracingConfig prometheusTracingConfig = instance = instance != null ? instance : new PrometheusTracingConfig();
        if (instance != null) {
            this.withClientType(instance.getClientType());
            this.withCompression(instance.getCompression());
            this.withEndpoint(instance.getEndpoint());
            this.withHeaders(instance.getHeaders());
            this.withInsecure(instance.getInsecure());
            this.withSamplingFraction(instance.getSamplingFraction());
            this.withTimeout(instance.getTimeout());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrometheusTracingConfigFluent that = (PrometheusTracingConfigFluent)o;
        if (!Objects.equals(this.clientType, that.clientType)) {
            return false;
        }
        if (!Objects.equals(this.compression, that.compression)) {
            return false;
        }
        if (!Objects.equals(this.endpoint, that.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.insecure, that.insecure)) {
            return false;
        }
        if (!Objects.equals(this.samplingFraction, that.samplingFraction)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getCompression() {
        return this.compression;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Boolean getInsecure() {
        return this.insecure;
    }

    public Quantity getSamplingFraction() {
        return this.samplingFraction;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasClientType() {
        return this.clientType != null;
    }

    public boolean hasCompression() {
        return this.compression != null;
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public boolean hasInsecure() {
        return this.insecure != null;
    }

    public boolean hasSamplingFraction() {
        return this.samplingFraction != null;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientType, this.compression, this.endpoint, this.headers, this.insecure, this.samplingFraction, this.timeout, this.tlsConfig, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)this;
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)this;
    }

    public A removeFromHeaders(Map<String, String> map) {
        if (this.headers == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientType != null) {
            sb.append("clientType:");
            sb.append(this.clientType);
            sb.append(",");
        }
        if (this.compression != null) {
            sb.append("compression:");
            sb.append(this.compression);
            sb.append(",");
        }
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append(this.endpoint);
            sb.append(",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers);
            sb.append(",");
        }
        if (this.insecure != null) {
            sb.append("insecure:");
            sb.append(this.insecure);
            sb.append(",");
        }
        if (this.samplingFraction != null) {
            sb.append("samplingFraction:");
            sb.append(this.samplingFraction);
            sb.append(",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout);
            sb.append(",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withClientType(String clientType) {
        this.clientType = clientType;
        return (A)this;
    }

    public A withCompression(String compression) {
        this.compression = compression;
        return (A)this;
    }

    public A withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return (A)this;
    }

    public <K, V> A withHeaders(Map<String, String> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, String>(headers);
        return (A)this;
    }

    public A withInsecure() {
        return this.withInsecure(true);
    }

    public A withInsecure(Boolean insecure) {
        this.insecure = insecure;
        return (A)this;
    }

    public A withNewSamplingFraction(String amount) {
        return this.withSamplingFraction(new Quantity(amount));
    }

    public A withNewSamplingFraction(String amount, String format) {
        return this.withSamplingFraction(new Quantity(amount, format));
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNested(item);
    }

    public A withSamplingFraction(Quantity samplingFraction) {
        this.samplingFraction = samplingFraction;
        return (A)this;
    }

    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)this;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public class TlsConfigNested<N>
    extends TLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PrometheusTracingConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }
}

