/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OTLPConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OTLPConfigFluent<A extends OTLPConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean convertHistogramsToNHCB;
    private List<String> ignoreResourceAttributes = new ArrayList<String>();
    private Boolean keepIdentifyingResourceAttributes;
    private Boolean promoteAllResourceAttributes;
    private List<String> promoteResourceAttributes = new ArrayList<String>();
    private String translationStrategy;

    public OTLPConfigFluent() {
    }

    public OTLPConfigFluent(OTLPConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToIgnoreResourceAttributes(Collection<String> items) {
        if (this.ignoreResourceAttributes == null) {
            this.ignoreResourceAttributes = new ArrayList<String>();
        }
        for (String item : items) {
            this.ignoreResourceAttributes.add(item);
        }
        return (A)this;
    }

    public A addAllToPromoteResourceAttributes(Collection<String> items) {
        if (this.promoteResourceAttributes == null) {
            this.promoteResourceAttributes = new ArrayList<String>();
        }
        for (String item : items) {
            this.promoteResourceAttributes.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToIgnoreResourceAttributes(String ... items) {
        if (this.ignoreResourceAttributes == null) {
            this.ignoreResourceAttributes = new ArrayList<String>();
        }
        for (String item : items) {
            this.ignoreResourceAttributes.add(item);
        }
        return (A)this;
    }

    public A addToIgnoreResourceAttributes(int index, String item) {
        if (this.ignoreResourceAttributes == null) {
            this.ignoreResourceAttributes = new ArrayList<String>();
        }
        this.ignoreResourceAttributes.add(index, item);
        return (A)this;
    }

    public A addToPromoteResourceAttributes(String ... items) {
        if (this.promoteResourceAttributes == null) {
            this.promoteResourceAttributes = new ArrayList<String>();
        }
        for (String item : items) {
            this.promoteResourceAttributes.add(item);
        }
        return (A)this;
    }

    public A addToPromoteResourceAttributes(int index, String item) {
        if (this.promoteResourceAttributes == null) {
            this.promoteResourceAttributes = new ArrayList<String>();
        }
        this.promoteResourceAttributes.add(index, item);
        return (A)this;
    }

    protected void copyInstance(OTLPConfig instance) {
        OTLPConfig oTLPConfig = instance = instance != null ? instance : new OTLPConfig();
        if (instance != null) {
            this.withConvertHistogramsToNHCB(instance.getConvertHistogramsToNHCB());
            this.withIgnoreResourceAttributes(instance.getIgnoreResourceAttributes());
            this.withKeepIdentifyingResourceAttributes(instance.getKeepIdentifyingResourceAttributes());
            this.withPromoteAllResourceAttributes(instance.getPromoteAllResourceAttributes());
            this.withPromoteResourceAttributes(instance.getPromoteResourceAttributes());
            this.withTranslationStrategy(instance.getTranslationStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OTLPConfigFluent that = (OTLPConfigFluent)o;
        if (!Objects.equals(this.convertHistogramsToNHCB, that.convertHistogramsToNHCB)) {
            return false;
        }
        if (!Objects.equals(this.ignoreResourceAttributes, that.ignoreResourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.keepIdentifyingResourceAttributes, that.keepIdentifyingResourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.promoteAllResourceAttributes, that.promoteAllResourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.promoteResourceAttributes, that.promoteResourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.translationStrategy, that.translationStrategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getConvertHistogramsToNHCB() {
        return this.convertHistogramsToNHCB;
    }

    public String getFirstIgnoreResourceAttribute() {
        return this.ignoreResourceAttributes.get(0);
    }

    public String getFirstPromoteResourceAttribute() {
        return this.promoteResourceAttributes.get(0);
    }

    public String getIgnoreResourceAttribute(int index) {
        return this.ignoreResourceAttributes.get(index);
    }

    public List<String> getIgnoreResourceAttributes() {
        return this.ignoreResourceAttributes;
    }

    public Boolean getKeepIdentifyingResourceAttributes() {
        return this.keepIdentifyingResourceAttributes;
    }

    public String getLastIgnoreResourceAttribute() {
        return this.ignoreResourceAttributes.get(this.ignoreResourceAttributes.size() - 1);
    }

    public String getLastPromoteResourceAttribute() {
        return this.promoteResourceAttributes.get(this.promoteResourceAttributes.size() - 1);
    }

    public String getMatchingIgnoreResourceAttribute(Predicate<String> predicate) {
        for (String item : this.ignoreResourceAttributes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingPromoteResourceAttribute(Predicate<String> predicate) {
        for (String item : this.promoteResourceAttributes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Boolean getPromoteAllResourceAttributes() {
        return this.promoteAllResourceAttributes;
    }

    public String getPromoteResourceAttribute(int index) {
        return this.promoteResourceAttributes.get(index);
    }

    public List<String> getPromoteResourceAttributes() {
        return this.promoteResourceAttributes;
    }

    public String getTranslationStrategy() {
        return this.translationStrategy;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConvertHistogramsToNHCB() {
        return this.convertHistogramsToNHCB != null;
    }

    public boolean hasIgnoreResourceAttributes() {
        return this.ignoreResourceAttributes != null && !this.ignoreResourceAttributes.isEmpty();
    }

    public boolean hasKeepIdentifyingResourceAttributes() {
        return this.keepIdentifyingResourceAttributes != null;
    }

    public boolean hasMatchingIgnoreResourceAttribute(Predicate<String> predicate) {
        for (String item : this.ignoreResourceAttributes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingPromoteResourceAttribute(Predicate<String> predicate) {
        for (String item : this.promoteResourceAttributes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPromoteAllResourceAttributes() {
        return this.promoteAllResourceAttributes != null;
    }

    public boolean hasPromoteResourceAttributes() {
        return this.promoteResourceAttributes != null && !this.promoteResourceAttributes.isEmpty();
    }

    public boolean hasTranslationStrategy() {
        return this.translationStrategy != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.convertHistogramsToNHCB, this.ignoreResourceAttributes, this.keepIdentifyingResourceAttributes, this.promoteAllResourceAttributes, this.promoteResourceAttributes, this.translationStrategy, this.additionalProperties);
    }

    public A removeAllFromIgnoreResourceAttributes(Collection<String> items) {
        if (this.ignoreResourceAttributes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ignoreResourceAttributes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPromoteResourceAttributes(Collection<String> items) {
        if (this.promoteResourceAttributes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.promoteResourceAttributes.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromIgnoreResourceAttributes(String ... items) {
        if (this.ignoreResourceAttributes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ignoreResourceAttributes.remove(item);
        }
        return (A)this;
    }

    public A removeFromPromoteResourceAttributes(String ... items) {
        if (this.promoteResourceAttributes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.promoteResourceAttributes.remove(item);
        }
        return (A)this;
    }

    public A setToIgnoreResourceAttributes(int index, String item) {
        if (this.ignoreResourceAttributes == null) {
            this.ignoreResourceAttributes = new ArrayList<String>();
        }
        this.ignoreResourceAttributes.set(index, item);
        return (A)this;
    }

    public A setToPromoteResourceAttributes(int index, String item) {
        if (this.promoteResourceAttributes == null) {
            this.promoteResourceAttributes = new ArrayList<String>();
        }
        this.promoteResourceAttributes.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.convertHistogramsToNHCB != null) {
            sb.append("convertHistogramsToNHCB:");
            sb.append(this.convertHistogramsToNHCB);
            sb.append(",");
        }
        if (this.ignoreResourceAttributes != null && !this.ignoreResourceAttributes.isEmpty()) {
            sb.append("ignoreResourceAttributes:");
            sb.append(this.ignoreResourceAttributes);
            sb.append(",");
        }
        if (this.keepIdentifyingResourceAttributes != null) {
            sb.append("keepIdentifyingResourceAttributes:");
            sb.append(this.keepIdentifyingResourceAttributes);
            sb.append(",");
        }
        if (this.promoteAllResourceAttributes != null) {
            sb.append("promoteAllResourceAttributes:");
            sb.append(this.promoteAllResourceAttributes);
            sb.append(",");
        }
        if (this.promoteResourceAttributes != null && !this.promoteResourceAttributes.isEmpty()) {
            sb.append("promoteResourceAttributes:");
            sb.append(this.promoteResourceAttributes);
            sb.append(",");
        }
        if (this.translationStrategy != null) {
            sb.append("translationStrategy:");
            sb.append(this.translationStrategy);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withConvertHistogramsToNHCB() {
        return this.withConvertHistogramsToNHCB(true);
    }

    public A withConvertHistogramsToNHCB(Boolean convertHistogramsToNHCB) {
        this.convertHistogramsToNHCB = convertHistogramsToNHCB;
        return (A)this;
    }

    public A withIgnoreResourceAttributes(List<String> ignoreResourceAttributes) {
        if (ignoreResourceAttributes != null) {
            this.ignoreResourceAttributes = new ArrayList<String>();
            for (String item : ignoreResourceAttributes) {
                this.addToIgnoreResourceAttributes(item);
            }
        } else {
            this.ignoreResourceAttributes = null;
        }
        return (A)this;
    }

    public A withIgnoreResourceAttributes(String ... ignoreResourceAttributes) {
        if (this.ignoreResourceAttributes != null) {
            this.ignoreResourceAttributes.clear();
            this._visitables.remove("ignoreResourceAttributes");
        }
        if (ignoreResourceAttributes != null) {
            for (String item : ignoreResourceAttributes) {
                this.addToIgnoreResourceAttributes(item);
            }
        }
        return (A)this;
    }

    public A withKeepIdentifyingResourceAttributes() {
        return this.withKeepIdentifyingResourceAttributes(true);
    }

    public A withKeepIdentifyingResourceAttributes(Boolean keepIdentifyingResourceAttributes) {
        this.keepIdentifyingResourceAttributes = keepIdentifyingResourceAttributes;
        return (A)this;
    }

    public A withPromoteAllResourceAttributes() {
        return this.withPromoteAllResourceAttributes(true);
    }

    public A withPromoteAllResourceAttributes(Boolean promoteAllResourceAttributes) {
        this.promoteAllResourceAttributes = promoteAllResourceAttributes;
        return (A)this;
    }

    public A withPromoteResourceAttributes(List<String> promoteResourceAttributes) {
        if (promoteResourceAttributes != null) {
            this.promoteResourceAttributes = new ArrayList<String>();
            for (String item : promoteResourceAttributes) {
                this.addToPromoteResourceAttributes(item);
            }
        } else {
            this.promoteResourceAttributes = null;
        }
        return (A)this;
    }

    public A withPromoteResourceAttributes(String ... promoteResourceAttributes) {
        if (this.promoteResourceAttributes != null) {
            this.promoteResourceAttributes.clear();
            this._visitables.remove("promoteResourceAttributes");
        }
        if (promoteResourceAttributes != null) {
            for (String item : promoteResourceAttributes) {
                this.addToPromoteResourceAttributes(item);
            }
        }
        return (A)this;
    }

    public A withTranslationStrategy(String translationStrategy) {
        this.translationStrategy = translationStrategy;
        return (A)this;
    }
}

