/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OAuth2Fluent<A extends OAuth2Fluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private SecretOrConfigMapBuilder clientId;
    private SecretKeySelector clientSecret;
    private Map<String, String> endpointParams;
    private String noProxy;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyUrl;
    private List<String> scopes = new ArrayList<String>();
    private SafeTLSConfigBuilder tlsConfig;
    private String tokenUrl;

    public OAuth2Fluent() {
    }

    public OAuth2Fluent(OAuth2 instance) {
        this.copyInstance(instance);
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToEndpointParams(Map<String, String> map) {
        if (this.endpointParams == null && map != null) {
            this.endpointParams = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.endpointParams.putAll(map);
        }
        return (A)this;
    }

    public A addToEndpointParams(String key, String value) {
        if (this.endpointParams == null && key != null && value != null) {
            this.endpointParams = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.endpointParams.put(key, value);
        }
        return (A)this;
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)this;
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)this;
    }

    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    public SecretOrConfigMap buildClientId() {
        return this.clientId != null ? this.clientId.build() : null;
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    protected void copyInstance(OAuth2 instance) {
        OAuth2 oAuth2 = instance = instance != null ? instance : new OAuth2();
        if (instance != null) {
            this.withClientId(instance.getClientId());
            this.withClientSecret(instance.getClientSecret());
            this.withEndpointParams(instance.getEndpointParams());
            this.withNoProxy(instance.getNoProxy());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyUrl(instance.getProxyUrl());
            this.withScopes(instance.getScopes());
            this.withTlsConfig(instance.getTlsConfig());
            this.withTokenUrl(instance.getTokenUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClientIdNested<A> editClientId() {
        return this.withNewClientIdLike(Optional.ofNullable(this.buildClientId()).orElse(null));
    }

    public ClientIdNested<A> editOrNewClientId() {
        return this.withNewClientIdLike(Optional.ofNullable(this.buildClientId()).orElse(new SecretOrConfigMapBuilder().build()));
    }

    public ClientIdNested<A> editOrNewClientIdLike(SecretOrConfigMap item) {
        return this.withNewClientIdLike(Optional.ofNullable(this.buildClientId()).orElse(item));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2Fluent that = (OAuth2Fluent)o;
        if (!Objects.equals(this.clientId, that.clientId)) {
            return false;
        }
        if (!Objects.equals(this.clientSecret, that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.endpointParams, that.endpointParams)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.scopes, that.scopes)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.tokenUrl, that.tokenUrl)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SecretKeySelector getClientSecret() {
        return this.clientSecret;
    }

    public Map<String, String> getEndpointParams() {
        return this.endpointParams;
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasClientId() {
        return this.clientId != null;
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public boolean hasEndpointParams() {
        return this.endpointParams != null;
    }

    public boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public boolean hasTokenUrl() {
        return this.tokenUrl != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.endpointParams, this.noProxy, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyUrl, this.scopes, this.tlsConfig, this.tokenUrl, this.additionalProperties);
    }

    public A removeAllFromScopes(Collection<String> items) {
        if (this.scopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromEndpointParams(String key) {
        if (this.endpointParams == null) {
            return (A)this;
        }
        if (key != null && this.endpointParams != null) {
            this.endpointParams.remove(key);
        }
        return (A)this;
    }

    public A removeFromEndpointParams(Map<String, String> map) {
        if (this.endpointParams == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.endpointParams == null) continue;
                this.endpointParams.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromScopes(String ... items) {
        if (this.scopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientId != null) {
            sb.append("clientId:");
            sb.append(this.clientId);
            sb.append(",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(this.clientSecret);
            sb.append(",");
        }
        if (this.endpointParams != null && !this.endpointParams.isEmpty()) {
            sb.append("endpointParams:");
            sb.append(this.endpointParams);
            sb.append(",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy);
            sb.append(",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(this.proxyConnectHeader);
            sb.append(",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment);
            sb.append(",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl);
            sb.append(",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes);
            sb.append(",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig);
            sb.append(",");
        }
        if (this.tokenUrl != null) {
            sb.append("tokenUrl:");
            sb.append(this.tokenUrl);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withClientId(SecretOrConfigMap clientId) {
        this._visitables.remove("clientId");
        if (clientId != null) {
            this.clientId = new SecretOrConfigMapBuilder(clientId);
            this._visitables.get("clientId").add(this.clientId);
        } else {
            this.clientId = null;
            this._visitables.get("clientId").remove(this.clientId);
        }
        return (A)this;
    }

    public A withClientSecret(SecretKeySelector clientSecret) {
        this.clientSecret = clientSecret;
        return (A)this;
    }

    public <K, V> A withEndpointParams(Map<String, String> endpointParams) {
        this.endpointParams = endpointParams == null ? null : new LinkedHashMap<String, String>(endpointParams);
        return (A)this;
    }

    public ClientIdNested<A> withNewClientId() {
        return new ClientIdNested(null);
    }

    public ClientIdNested<A> withNewClientIdLike(SecretOrConfigMap item) {
        return new ClientIdNested(item);
    }

    public A withNewClientSecret(String key, String name, Boolean optional) {
        return this.withClientSecret(new SecretKeySelector(key, name, optional));
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)this;
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)this;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)this;
    }

    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
            this._visitables.remove("scopes");
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public A withTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return (A)this;
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OAuth2Fluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class ClientIdNested<N>
    extends SecretOrConfigMapFluent<ClientIdNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;

        ClientIdNested(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OAuth2Fluent.this.withClientId(this.builder.build());
        }

        public N endClientId() {
            return this.and();
        }
    }
}

