/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.monitoring.v1.NativeHistogramConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class NativeHistogramConfigFluent<A extends NativeHistogramConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean convertClassicHistogramsToNHCB;
    private Long nativeHistogramBucketLimit;
    private Quantity nativeHistogramMinBucketFactor;
    private Boolean scrapeClassicHistograms;

    public NativeHistogramConfigFluent() {
    }

    public NativeHistogramConfigFluent(NativeHistogramConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    protected void copyInstance(NativeHistogramConfig instance) {
        NativeHistogramConfig nativeHistogramConfig = instance = instance != null ? instance : new NativeHistogramConfig();
        if (instance != null) {
            this.withConvertClassicHistogramsToNHCB(instance.getConvertClassicHistogramsToNHCB());
            this.withNativeHistogramBucketLimit(instance.getNativeHistogramBucketLimit());
            this.withNativeHistogramMinBucketFactor(instance.getNativeHistogramMinBucketFactor());
            this.withScrapeClassicHistograms(instance.getScrapeClassicHistograms());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NativeHistogramConfigFluent that = (NativeHistogramConfigFluent)o;
        if (!Objects.equals(this.convertClassicHistogramsToNHCB, that.convertClassicHistogramsToNHCB)) {
            return false;
        }
        if (!Objects.equals(this.nativeHistogramBucketLimit, that.nativeHistogramBucketLimit)) {
            return false;
        }
        if (!Objects.equals(this.nativeHistogramMinBucketFactor, that.nativeHistogramMinBucketFactor)) {
            return false;
        }
        if (!Objects.equals(this.scrapeClassicHistograms, that.scrapeClassicHistograms)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getConvertClassicHistogramsToNHCB() {
        return this.convertClassicHistogramsToNHCB;
    }

    public Long getNativeHistogramBucketLimit() {
        return this.nativeHistogramBucketLimit;
    }

    public Quantity getNativeHistogramMinBucketFactor() {
        return this.nativeHistogramMinBucketFactor;
    }

    public Boolean getScrapeClassicHistograms() {
        return this.scrapeClassicHistograms;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConvertClassicHistogramsToNHCB() {
        return this.convertClassicHistogramsToNHCB != null;
    }

    public boolean hasNativeHistogramBucketLimit() {
        return this.nativeHistogramBucketLimit != null;
    }

    public boolean hasNativeHistogramMinBucketFactor() {
        return this.nativeHistogramMinBucketFactor != null;
    }

    public boolean hasScrapeClassicHistograms() {
        return this.scrapeClassicHistograms != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.convertClassicHistogramsToNHCB, this.nativeHistogramBucketLimit, this.nativeHistogramMinBucketFactor, this.scrapeClassicHistograms, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.convertClassicHistogramsToNHCB != null) {
            sb.append("convertClassicHistogramsToNHCB:");
            sb.append(this.convertClassicHistogramsToNHCB);
            sb.append(",");
        }
        if (this.nativeHistogramBucketLimit != null) {
            sb.append("nativeHistogramBucketLimit:");
            sb.append(this.nativeHistogramBucketLimit);
            sb.append(",");
        }
        if (this.nativeHistogramMinBucketFactor != null) {
            sb.append("nativeHistogramMinBucketFactor:");
            sb.append(this.nativeHistogramMinBucketFactor);
            sb.append(",");
        }
        if (this.scrapeClassicHistograms != null) {
            sb.append("scrapeClassicHistograms:");
            sb.append(this.scrapeClassicHistograms);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withConvertClassicHistogramsToNHCB() {
        return this.withConvertClassicHistogramsToNHCB(true);
    }

    public A withConvertClassicHistogramsToNHCB(Boolean convertClassicHistogramsToNHCB) {
        this.convertClassicHistogramsToNHCB = convertClassicHistogramsToNHCB;
        return (A)this;
    }

    public A withNativeHistogramBucketLimit(Long nativeHistogramBucketLimit) {
        this.nativeHistogramBucketLimit = nativeHistogramBucketLimit;
        return (A)this;
    }

    public A withNativeHistogramMinBucketFactor(Quantity nativeHistogramMinBucketFactor) {
        this.nativeHistogramMinBucketFactor = nativeHistogramMinBucketFactor;
        return (A)this;
    }

    public A withNewNativeHistogramMinBucketFactor(String amount) {
        return this.withNativeHistogramMinBucketFactor(new Quantity(amount));
    }

    public A withNewNativeHistogramMinBucketFactor(String amount, String format) {
        return this.withNativeHistogramMinBucketFactor(new Quantity(amount, format));
    }

    public A withScrapeClassicHistograms() {
        return this.withScrapeClassicHistograms(true);
    }

    public A withScrapeClassicHistograms(Boolean scrapeClassicHistograms) {
        this.scrapeClassicHistograms = scrapeClassicHistograms;
        return (A)this;
    }
}

