/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.ConfigResourceStatus;
import io.fabric8.openshift.api.model.monitoring.v1.WorkloadBinding;
import io.fabric8.openshift.api.model.monitoring.v1.WorkloadBindingBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.WorkloadBindingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConfigResourceStatusFluent<A extends ConfigResourceStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<WorkloadBindingBuilder> bindings = new ArrayList();

    public ConfigResourceStatusFluent() {
    }

    public ConfigResourceStatusFluent(ConfigResourceStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToBindings(Collection<WorkloadBinding> items) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        for (WorkloadBinding item : items) {
            WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
            this._visitables.get("bindings").add(builder);
            this.bindings.add(builder);
        }
        return (A)this;
    }

    public BindingsNested<A> addNewBinding() {
        return new BindingsNested(-1, null);
    }

    public BindingsNested<A> addNewBindingLike(WorkloadBinding item) {
        return new BindingsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToBindings(WorkloadBinding ... items) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        for (WorkloadBinding item : items) {
            WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
            this._visitables.get("bindings").add(builder);
            this.bindings.add(builder);
        }
        return (A)this;
    }

    public A addToBindings(int index, WorkloadBinding item) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
        if (index < 0 || index >= this.bindings.size()) {
            this._visitables.get("bindings").add(builder);
            this.bindings.add(builder);
        } else {
            this._visitables.get("bindings").add(builder);
            this.bindings.add(index, builder);
        }
        return (A)this;
    }

    public WorkloadBinding buildBinding(int index) {
        return this.bindings.get(index).build();
    }

    public List<WorkloadBinding> buildBindings() {
        return this.bindings != null ? ConfigResourceStatusFluent.build(this.bindings) : null;
    }

    public WorkloadBinding buildFirstBinding() {
        return this.bindings.get(0).build();
    }

    public WorkloadBinding buildLastBinding() {
        return this.bindings.get(this.bindings.size() - 1).build();
    }

    public WorkloadBinding buildMatchingBinding(Predicate<WorkloadBindingBuilder> predicate) {
        for (WorkloadBindingBuilder item : this.bindings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(ConfigResourceStatus instance) {
        ConfigResourceStatus configResourceStatus = instance = instance != null ? instance : new ConfigResourceStatus();
        if (instance != null) {
            this.withBindings(instance.getBindings());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BindingsNested<A> editBinding(int index) {
        if (this.bindings.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "bindings"));
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    public BindingsNested<A> editFirstBinding() {
        if (this.bindings.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "bindings"));
        }
        return this.setNewBindingLike(0, this.buildBinding(0));
    }

    public BindingsNested<A> editLastBinding() {
        int index = this.bindings.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "bindings"));
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    public BindingsNested<A> editMatchingBinding(Predicate<WorkloadBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.bindings.size(); ++i) {
            if (!predicate.test(this.bindings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "bindings"));
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigResourceStatusFluent that = (ConfigResourceStatusFluent)o;
        if (!Objects.equals(this.bindings, that.bindings)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBindings() {
        return this.bindings != null && !this.bindings.isEmpty();
    }

    public boolean hasMatchingBinding(Predicate<WorkloadBindingBuilder> predicate) {
        for (WorkloadBindingBuilder item : this.bindings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bindings, this.additionalProperties);
    }

    public A removeAllFromBindings(Collection<WorkloadBinding> items) {
        if (this.bindings == null) {
            return (A)this;
        }
        for (WorkloadBinding item : items) {
            WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
            this._visitables.get("bindings").remove(builder);
            this.bindings.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromBindings(WorkloadBinding ... items) {
        if (this.bindings == null) {
            return (A)this;
        }
        for (WorkloadBinding item : items) {
            WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
            this._visitables.get("bindings").remove(builder);
            this.bindings.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromBindings(Predicate<WorkloadBindingBuilder> predicate) {
        if (this.bindings == null) {
            return (A)this;
        }
        Iterator<WorkloadBindingBuilder> each = this.bindings.iterator();
        Object visitables = this._visitables.get("bindings");
        while (each.hasNext()) {
            WorkloadBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public BindingsNested<A> setNewBindingLike(int index, WorkloadBinding item) {
        return new BindingsNested(index, item);
    }

    public A setToBindings(int index, WorkloadBinding item) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
        if (index < 0 || index >= this.bindings.size()) {
            this._visitables.get("bindings").add(builder);
            this.bindings.add(builder);
        } else {
            this._visitables.get("bindings").add(builder);
            this.bindings.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindings != null && !this.bindings.isEmpty()) {
            sb.append("bindings:");
            sb.append(this.bindings);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withBindings(List<WorkloadBinding> bindings) {
        if (this.bindings != null) {
            this._visitables.get("bindings").clear();
        }
        if (bindings != null) {
            this.bindings = new ArrayList();
            for (WorkloadBinding item : bindings) {
                this.addToBindings(item);
            }
        } else {
            this.bindings = null;
        }
        return (A)this;
    }

    public A withBindings(WorkloadBinding ... bindings) {
        if (this.bindings != null) {
            this.bindings.clear();
            this._visitables.remove("bindings");
        }
        if (bindings != null) {
            for (WorkloadBinding item : bindings) {
                this.addToBindings(item);
            }
        }
        return (A)this;
    }

    public class BindingsNested<N>
    extends WorkloadBindingFluent<BindingsNested<N>>
    implements Nested<N> {
        WorkloadBindingBuilder builder;
        int index;

        BindingsNested(int index, WorkloadBinding item) {
            this.index = index;
            this.builder = new WorkloadBindingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigResourceStatusFluent.this.setToBindings(this.index, this.builder.build());
        }

        public N endBinding() {
            return this.and();
        }
    }
}

