/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.AzureAD;
import io.fabric8.openshift.api.model.monitoring.v1.AzureOAuth;
import io.fabric8.openshift.api.model.monitoring.v1.AzureOAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AzureOAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.AzureSDK;
import io.fabric8.openshift.api.model.monitoring.v1.AzureSDKBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AzureSDKFluent;
import io.fabric8.openshift.api.model.monitoring.v1.ManagedIdentity;
import io.fabric8.openshift.api.model.monitoring.v1.ManagedIdentityBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ManagedIdentityFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AzureADFluent<A extends AzureADFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String cloud;
    private ManagedIdentityBuilder managedIdentity;
    private AzureOAuthBuilder oauth;
    private AzureSDKBuilder sdk;

    public AzureADFluent() {
    }

    public AzureADFluent(AzureAD instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public ManagedIdentity buildManagedIdentity() {
        return this.managedIdentity != null ? this.managedIdentity.build() : null;
    }

    public AzureOAuth buildOauth() {
        return this.oauth != null ? this.oauth.build() : null;
    }

    public AzureSDK buildSdk() {
        return this.sdk != null ? this.sdk.build() : null;
    }

    protected void copyInstance(AzureAD instance) {
        AzureAD azureAD = instance = instance != null ? instance : new AzureAD();
        if (instance != null) {
            this.withCloud(instance.getCloud());
            this.withManagedIdentity(instance.getManagedIdentity());
            this.withOauth(instance.getOauth());
            this.withSdk(instance.getSdk());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ManagedIdentityNested<A> editManagedIdentity() {
        return this.withNewManagedIdentityLike(Optional.ofNullable(this.buildManagedIdentity()).orElse(null));
    }

    public OauthNested<A> editOauth() {
        return this.withNewOauthLike(Optional.ofNullable(this.buildOauth()).orElse(null));
    }

    public ManagedIdentityNested<A> editOrNewManagedIdentity() {
        return this.withNewManagedIdentityLike(Optional.ofNullable(this.buildManagedIdentity()).orElse(new ManagedIdentityBuilder().build()));
    }

    public ManagedIdentityNested<A> editOrNewManagedIdentityLike(ManagedIdentity item) {
        return this.withNewManagedIdentityLike(Optional.ofNullable(this.buildManagedIdentity()).orElse(item));
    }

    public OauthNested<A> editOrNewOauth() {
        return this.withNewOauthLike(Optional.ofNullable(this.buildOauth()).orElse(new AzureOAuthBuilder().build()));
    }

    public OauthNested<A> editOrNewOauthLike(AzureOAuth item) {
        return this.withNewOauthLike(Optional.ofNullable(this.buildOauth()).orElse(item));
    }

    public SdkNested<A> editOrNewSdk() {
        return this.withNewSdkLike(Optional.ofNullable(this.buildSdk()).orElse(new AzureSDKBuilder().build()));
    }

    public SdkNested<A> editOrNewSdkLike(AzureSDK item) {
        return this.withNewSdkLike(Optional.ofNullable(this.buildSdk()).orElse(item));
    }

    public SdkNested<A> editSdk() {
        return this.withNewSdkLike(Optional.ofNullable(this.buildSdk()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureADFluent that = (AzureADFluent)o;
        if (!Objects.equals(this.cloud, that.cloud)) {
            return false;
        }
        if (!Objects.equals(this.managedIdentity, that.managedIdentity)) {
            return false;
        }
        if (!Objects.equals(this.oauth, that.oauth)) {
            return false;
        }
        if (!Objects.equals(this.sdk, that.sdk)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCloud() {
        return this.cloud;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCloud() {
        return this.cloud != null;
    }

    public boolean hasManagedIdentity() {
        return this.managedIdentity != null;
    }

    public boolean hasOauth() {
        return this.oauth != null;
    }

    public boolean hasSdk() {
        return this.sdk != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cloud, this.managedIdentity, this.oauth, this.sdk, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cloud != null) {
            sb.append("cloud:");
            sb.append(this.cloud);
            sb.append(",");
        }
        if (this.managedIdentity != null) {
            sb.append("managedIdentity:");
            sb.append(this.managedIdentity);
            sb.append(",");
        }
        if (this.oauth != null) {
            sb.append("oauth:");
            sb.append(this.oauth);
            sb.append(",");
        }
        if (this.sdk != null) {
            sb.append("sdk:");
            sb.append(this.sdk);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCloud(String cloud) {
        this.cloud = cloud;
        return (A)this;
    }

    public A withManagedIdentity(ManagedIdentity managedIdentity) {
        this._visitables.remove("managedIdentity");
        if (managedIdentity != null) {
            this.managedIdentity = new ManagedIdentityBuilder(managedIdentity);
            this._visitables.get("managedIdentity").add(this.managedIdentity);
        } else {
            this.managedIdentity = null;
            this._visitables.get("managedIdentity").remove(this.managedIdentity);
        }
        return (A)this;
    }

    public ManagedIdentityNested<A> withNewManagedIdentity() {
        return new ManagedIdentityNested(null);
    }

    public A withNewManagedIdentity(String clientId) {
        return this.withManagedIdentity(new ManagedIdentity(clientId));
    }

    public ManagedIdentityNested<A> withNewManagedIdentityLike(ManagedIdentity item) {
        return new ManagedIdentityNested(item);
    }

    public OauthNested<A> withNewOauth() {
        return new OauthNested(null);
    }

    public OauthNested<A> withNewOauthLike(AzureOAuth item) {
        return new OauthNested(item);
    }

    public SdkNested<A> withNewSdk() {
        return new SdkNested(null);
    }

    public A withNewSdk(String tenantId) {
        return this.withSdk(new AzureSDK(tenantId));
    }

    public SdkNested<A> withNewSdkLike(AzureSDK item) {
        return new SdkNested(item);
    }

    public A withOauth(AzureOAuth oauth) {
        this._visitables.remove("oauth");
        if (oauth != null) {
            this.oauth = new AzureOAuthBuilder(oauth);
            this._visitables.get("oauth").add(this.oauth);
        } else {
            this.oauth = null;
            this._visitables.get("oauth").remove(this.oauth);
        }
        return (A)this;
    }

    public A withSdk(AzureSDK sdk) {
        this._visitables.remove("sdk");
        if (sdk != null) {
            this.sdk = new AzureSDKBuilder(sdk);
            this._visitables.get("sdk").add(this.sdk);
        } else {
            this.sdk = null;
            this._visitables.get("sdk").remove(this.sdk);
        }
        return (A)this;
    }

    public class SdkNested<N>
    extends AzureSDKFluent<SdkNested<N>>
    implements Nested<N> {
        AzureSDKBuilder builder;

        SdkNested(AzureSDK item) {
            this.builder = new AzureSDKBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AzureADFluent.this.withSdk(this.builder.build());
        }

        public N endSdk() {
            return this.and();
        }
    }

    public class OauthNested<N>
    extends AzureOAuthFluent<OauthNested<N>>
    implements Nested<N> {
        AzureOAuthBuilder builder;

        OauthNested(AzureOAuth item) {
            this.builder = new AzureOAuthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AzureADFluent.this.withOauth(this.builder.build());
        }

        public N endOauth() {
            return this.and();
        }
    }

    public class ManagedIdentityNested<N>
    extends ManagedIdentityFluent<ManagedIdentityNested<N>>
    implements Nested<N> {
        ManagedIdentityBuilder builder;

        ManagedIdentityNested(ManagedIdentity item) {
            this.builder = new ManagedIdentityBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AzureADFluent.this.withManagedIdentity(this.builder.build());
        }

        public N endManagedIdentity() {
            return this.and();
        }
    }
}

