/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.AlertingSpec;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpoints;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AlertingSpecFluent<A extends AlertingSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<AlertmanagerEndpointsBuilder> alertmanagers = new ArrayList();

    public AlertingSpecFluent() {
    }

    public AlertingSpecFluent(AlertingSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToAlertmanagers(Collection<AlertmanagerEndpoints> items) {
        if (this.alertmanagers == null) {
            this.alertmanagers = new ArrayList();
        }
        for (AlertmanagerEndpoints item : items) {
            AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
            this._visitables.get("alertmanagers").add(builder);
            this.alertmanagers.add(builder);
        }
        return (A)this;
    }

    public AlertmanagersNested<A> addNewAlertmanager() {
        return new AlertmanagersNested(-1, null);
    }

    public AlertmanagersNested<A> addNewAlertmanagerLike(AlertmanagerEndpoints item) {
        return new AlertmanagersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAlertmanagers(AlertmanagerEndpoints ... items) {
        if (this.alertmanagers == null) {
            this.alertmanagers = new ArrayList();
        }
        for (AlertmanagerEndpoints item : items) {
            AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
            this._visitables.get("alertmanagers").add(builder);
            this.alertmanagers.add(builder);
        }
        return (A)this;
    }

    public A addToAlertmanagers(int index, AlertmanagerEndpoints item) {
        if (this.alertmanagers == null) {
            this.alertmanagers = new ArrayList();
        }
        AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
        if (index < 0 || index >= this.alertmanagers.size()) {
            this._visitables.get("alertmanagers").add(builder);
            this.alertmanagers.add(builder);
        } else {
            this._visitables.get("alertmanagers").add(builder);
            this.alertmanagers.add(index, builder);
        }
        return (A)this;
    }

    public AlertmanagerEndpoints buildAlertmanager(int index) {
        return this.alertmanagers.get(index).build();
    }

    public List<AlertmanagerEndpoints> buildAlertmanagers() {
        return this.alertmanagers != null ? AlertingSpecFluent.build(this.alertmanagers) : null;
    }

    public AlertmanagerEndpoints buildFirstAlertmanager() {
        return this.alertmanagers.get(0).build();
    }

    public AlertmanagerEndpoints buildLastAlertmanager() {
        return this.alertmanagers.get(this.alertmanagers.size() - 1).build();
    }

    public AlertmanagerEndpoints buildMatchingAlertmanager(Predicate<AlertmanagerEndpointsBuilder> predicate) {
        for (AlertmanagerEndpointsBuilder item : this.alertmanagers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(AlertingSpec instance) {
        AlertingSpec alertingSpec = instance = instance != null ? instance : new AlertingSpec();
        if (instance != null) {
            this.withAlertmanagers(instance.getAlertmanagers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AlertmanagersNested<A> editAlertmanager(int index) {
        if (this.alertmanagers.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "alertmanagers"));
        }
        return this.setNewAlertmanagerLike(index, this.buildAlertmanager(index));
    }

    public AlertmanagersNested<A> editFirstAlertmanager() {
        if (this.alertmanagers.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "alertmanagers"));
        }
        return this.setNewAlertmanagerLike(0, this.buildAlertmanager(0));
    }

    public AlertmanagersNested<A> editLastAlertmanager() {
        int index = this.alertmanagers.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "alertmanagers"));
        }
        return this.setNewAlertmanagerLike(index, this.buildAlertmanager(index));
    }

    public AlertmanagersNested<A> editMatchingAlertmanager(Predicate<AlertmanagerEndpointsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.alertmanagers.size(); ++i) {
            if (!predicate.test(this.alertmanagers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "alertmanagers"));
        }
        return this.setNewAlertmanagerLike(index, this.buildAlertmanager(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertingSpecFluent that = (AlertingSpecFluent)o;
        if (!Objects.equals(this.alertmanagers, that.alertmanagers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAlertmanagers() {
        return this.alertmanagers != null && !this.alertmanagers.isEmpty();
    }

    public boolean hasMatchingAlertmanager(Predicate<AlertmanagerEndpointsBuilder> predicate) {
        for (AlertmanagerEndpointsBuilder item : this.alertmanagers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alertmanagers, this.additionalProperties);
    }

    public A removeAllFromAlertmanagers(Collection<AlertmanagerEndpoints> items) {
        if (this.alertmanagers == null) {
            return (A)this;
        }
        for (AlertmanagerEndpoints item : items) {
            AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
            this._visitables.get("alertmanagers").remove(builder);
            this.alertmanagers.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromAlertmanagers(AlertmanagerEndpoints ... items) {
        if (this.alertmanagers == null) {
            return (A)this;
        }
        for (AlertmanagerEndpoints item : items) {
            AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
            this._visitables.get("alertmanagers").remove(builder);
            this.alertmanagers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAlertmanagers(Predicate<AlertmanagerEndpointsBuilder> predicate) {
        if (this.alertmanagers == null) {
            return (A)this;
        }
        Iterator<AlertmanagerEndpointsBuilder> each = this.alertmanagers.iterator();
        Object visitables = this._visitables.get("alertmanagers");
        while (each.hasNext()) {
            AlertmanagerEndpointsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public AlertmanagersNested<A> setNewAlertmanagerLike(int index, AlertmanagerEndpoints item) {
        return new AlertmanagersNested(index, item);
    }

    public A setToAlertmanagers(int index, AlertmanagerEndpoints item) {
        if (this.alertmanagers == null) {
            this.alertmanagers = new ArrayList();
        }
        AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
        if (index < 0 || index >= this.alertmanagers.size()) {
            this._visitables.get("alertmanagers").add(builder);
            this.alertmanagers.add(builder);
        } else {
            this._visitables.get("alertmanagers").add(builder);
            this.alertmanagers.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alertmanagers != null && !this.alertmanagers.isEmpty()) {
            sb.append("alertmanagers:");
            sb.append(this.alertmanagers);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAlertmanagers(List<AlertmanagerEndpoints> alertmanagers) {
        if (this.alertmanagers != null) {
            this._visitables.get("alertmanagers").clear();
        }
        if (alertmanagers != null) {
            this.alertmanagers = new ArrayList();
            for (AlertmanagerEndpoints item : alertmanagers) {
                this.addToAlertmanagers(item);
            }
        } else {
            this.alertmanagers = null;
        }
        return (A)this;
    }

    public A withAlertmanagers(AlertmanagerEndpoints ... alertmanagers) {
        if (this.alertmanagers != null) {
            this.alertmanagers.clear();
            this._visitables.remove("alertmanagers");
        }
        if (alertmanagers != null) {
            for (AlertmanagerEndpoints item : alertmanagers) {
                this.addToAlertmanagers(item);
            }
        }
        return (A)this;
    }

    public class AlertmanagersNested<N>
    extends AlertmanagerEndpointsFluent<AlertmanagersNested<N>>
    implements Nested<N> {
        AlertmanagerEndpointsBuilder builder;
        int index;

        AlertmanagersNested(int index, AlertmanagerEndpoints item) {
            this.index = index;
            this.builder = new AlertmanagerEndpointsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertingSpecFluent.this.setToAlertmanagers(this.index, this.builder.build());
        }

        public N endAlertmanager() {
            return this.and();
        }
    }
}

