/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.AlertRelabelConfigSpec;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AlertRelabelConfigSpecFluent<A extends AlertRelabelConfigSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<RelabelConfigBuilder> configs = new ArrayList();

    public AlertRelabelConfigSpecFluent() {
    }

    public AlertRelabelConfigSpecFluent(AlertRelabelConfigSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToConfigs(Collection<RelabelConfig> items) {
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("configs").add(builder);
            this.configs.add(builder);
        }
        return (A)this;
    }

    public ConfigsNested<A> addNewConfig() {
        return new ConfigsNested(-1, null);
    }

    public ConfigsNested<A> addNewConfigLike(RelabelConfig item) {
        return new ConfigsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToConfigs(RelabelConfig ... items) {
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("configs").add(builder);
            this.configs.add(builder);
        }
        return (A)this;
    }

    public A addToConfigs(int index, RelabelConfig item) {
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.configs.size()) {
            this._visitables.get("configs").add(builder);
            this.configs.add(builder);
        } else {
            this._visitables.get("configs").add(builder);
            this.configs.add(index, builder);
        }
        return (A)this;
    }

    public RelabelConfig buildConfig(int index) {
        return this.configs.get(index).build();
    }

    public List<RelabelConfig> buildConfigs() {
        return this.configs != null ? AlertRelabelConfigSpecFluent.build(this.configs) : null;
    }

    public RelabelConfig buildFirstConfig() {
        return this.configs.get(0).build();
    }

    public RelabelConfig buildLastConfig() {
        return this.configs.get(this.configs.size() - 1).build();
    }

    public RelabelConfig buildMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.configs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(AlertRelabelConfigSpec instance) {
        AlertRelabelConfigSpec alertRelabelConfigSpec = instance = instance != null ? instance : new AlertRelabelConfigSpec();
        if (instance != null) {
            this.withConfigs(instance.getConfigs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigsNested<A> editConfig(int index) {
        if (this.configs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "configs"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigsNested<A> editFirstConfig() {
        if (this.configs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "configs"));
        }
        return this.setNewConfigLike(0, this.buildConfig(0));
    }

    public ConfigsNested<A> editLastConfig() {
        int index = this.configs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "configs"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigsNested<A> editMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configs.size(); ++i) {
            if (!predicate.test(this.configs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "configs"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertRelabelConfigSpecFluent that = (AlertRelabelConfigSpecFluent)o;
        if (!Objects.equals(this.configs, that.configs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConfigs() {
        return this.configs != null && !this.configs.isEmpty();
    }

    public boolean hasMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.configs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configs, this.additionalProperties);
    }

    public A removeAllFromConfigs(Collection<RelabelConfig> items) {
        if (this.configs == null) {
            return (A)this;
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("configs").remove(builder);
            this.configs.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromConfigs(RelabelConfig ... items) {
        if (this.configs == null) {
            return (A)this;
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("configs").remove(builder);
            this.configs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConfigs(Predicate<RelabelConfigBuilder> predicate) {
        if (this.configs == null) {
            return (A)this;
        }
        Iterator<RelabelConfigBuilder> each = this.configs.iterator();
        Object visitables = this._visitables.get("configs");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ConfigsNested<A> setNewConfigLike(int index, RelabelConfig item) {
        return new ConfigsNested(index, item);
    }

    public A setToConfigs(int index, RelabelConfig item) {
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.configs.size()) {
            this._visitables.get("configs").add(builder);
            this.configs.add(builder);
        } else {
            this._visitables.get("configs").add(builder);
            this.configs.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configs != null && !this.configs.isEmpty()) {
            sb.append("configs:");
            sb.append(this.configs);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withConfigs(List<RelabelConfig> configs) {
        if (this.configs != null) {
            this._visitables.get("configs").clear();
        }
        if (configs != null) {
            this.configs = new ArrayList();
            for (RelabelConfig item : configs) {
                this.addToConfigs(item);
            }
        } else {
            this.configs = null;
        }
        return (A)this;
    }

    public A withConfigs(RelabelConfig ... configs) {
        if (this.configs != null) {
            this.configs.clear();
            this._visitables.remove("configs");
        }
        if (configs != null) {
            for (RelabelConfig item : configs) {
                this.addToConfigs(item);
            }
        }
        return (A)this;
    }

    public class ConfigsNested<N>
    extends RelabelConfigFluent<ConfigsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        ConfigsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertRelabelConfigSpecFluent.this.setToConfigs(this.index, this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }
}

