/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkBond;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMac;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMacBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMacFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NetworkDataLinkBondFluent<A extends NetworkDataLinkBondFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> bondLinks = new ArrayList<String>();
    private String bondMode;
    private String bondXmitHashPolicy;
    private String id;
    private NetworkLinkEthernetMacBuilder macAddress;
    private Integer mtu;

    public NetworkDataLinkBondFluent() {
    }

    public NetworkDataLinkBondFluent(NetworkDataLinkBond instance) {
        this.copyInstance(instance);
    }

    public A addAllToBondLinks(Collection<String> items) {
        if (this.bondLinks == null) {
            this.bondLinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.bondLinks.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToBondLinks(String ... items) {
        if (this.bondLinks == null) {
            this.bondLinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.bondLinks.add(item);
        }
        return (A)this;
    }

    public A addToBondLinks(int index, String item) {
        if (this.bondLinks == null) {
            this.bondLinks = new ArrayList<String>();
        }
        this.bondLinks.add(index, item);
        return (A)this;
    }

    public NetworkLinkEthernetMac buildMacAddress() {
        return this.macAddress != null ? this.macAddress.build() : null;
    }

    protected void copyInstance(NetworkDataLinkBond instance) {
        NetworkDataLinkBond networkDataLinkBond = instance = instance != null ? instance : new NetworkDataLinkBond();
        if (instance != null) {
            this.withBondLinks(instance.getBondLinks());
            this.withBondMode(instance.getBondMode());
            this.withBondXmitHashPolicy(instance.getBondXmitHashPolicy());
            this.withId(instance.getId());
            this.withMacAddress(instance.getMacAddress());
            this.withMtu(instance.getMtu());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MacAddressNested<A> editMacAddress() {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(null));
    }

    public MacAddressNested<A> editOrNewMacAddress() {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(new NetworkLinkEthernetMacBuilder().build()));
    }

    public MacAddressNested<A> editOrNewMacAddressLike(NetworkLinkEthernetMac item) {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataLinkBondFluent that = (NetworkDataLinkBondFluent)o;
        if (!Objects.equals(this.bondLinks, that.bondLinks)) {
            return false;
        }
        if (!Objects.equals(this.bondMode, that.bondMode)) {
            return false;
        }
        if (!Objects.equals(this.bondXmitHashPolicy, that.bondXmitHashPolicy)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.macAddress, that.macAddress)) {
            return false;
        }
        if (!Objects.equals(this.mtu, that.mtu)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBondLink(int index) {
        return this.bondLinks.get(index);
    }

    public List<String> getBondLinks() {
        return this.bondLinks;
    }

    public String getBondMode() {
        return this.bondMode;
    }

    public String getBondXmitHashPolicy() {
        return this.bondXmitHashPolicy;
    }

    public String getFirstBondLink() {
        return this.bondLinks.get(0);
    }

    public String getId() {
        return this.id;
    }

    public String getLastBondLink() {
        return this.bondLinks.get(this.bondLinks.size() - 1);
    }

    public String getMatchingBondLink(Predicate<String> predicate) {
        for (String item : this.bondLinks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBondLinks() {
        return this.bondLinks != null && !this.bondLinks.isEmpty();
    }

    public boolean hasBondMode() {
        return this.bondMode != null;
    }

    public boolean hasBondXmitHashPolicy() {
        return this.bondXmitHashPolicy != null;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean hasMacAddress() {
        return this.macAddress != null;
    }

    public boolean hasMatchingBondLink(Predicate<String> predicate) {
        for (String item : this.bondLinks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMtu() {
        return this.mtu != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bondLinks, this.bondMode, this.bondXmitHashPolicy, this.id, this.macAddress, this.mtu, this.additionalProperties);
    }

    public A removeAllFromBondLinks(Collection<String> items) {
        if (this.bondLinks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.bondLinks.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromBondLinks(String ... items) {
        if (this.bondLinks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.bondLinks.remove(item);
        }
        return (A)this;
    }

    public A setToBondLinks(int index, String item) {
        if (this.bondLinks == null) {
            this.bondLinks = new ArrayList<String>();
        }
        this.bondLinks.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bondLinks != null && !this.bondLinks.isEmpty()) {
            sb.append("bondLinks:");
            sb.append(this.bondLinks);
            sb.append(",");
        }
        if (this.bondMode != null) {
            sb.append("bondMode:");
            sb.append(this.bondMode);
            sb.append(",");
        }
        if (this.bondXmitHashPolicy != null) {
            sb.append("bondXmitHashPolicy:");
            sb.append(this.bondXmitHashPolicy);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id);
            sb.append(",");
        }
        if (this.macAddress != null) {
            sb.append("macAddress:");
            sb.append(this.macAddress);
            sb.append(",");
        }
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append(this.mtu);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withBondLinks(List<String> bondLinks) {
        if (bondLinks != null) {
            this.bondLinks = new ArrayList<String>();
            for (String item : bondLinks) {
                this.addToBondLinks(item);
            }
        } else {
            this.bondLinks = null;
        }
        return (A)this;
    }

    public A withBondLinks(String ... bondLinks) {
        if (this.bondLinks != null) {
            this.bondLinks.clear();
            this._visitables.remove("bondLinks");
        }
        if (bondLinks != null) {
            for (String item : bondLinks) {
                this.addToBondLinks(item);
            }
        }
        return (A)this;
    }

    public A withBondMode(String bondMode) {
        this.bondMode = bondMode;
        return (A)this;
    }

    public A withBondXmitHashPolicy(String bondXmitHashPolicy) {
        this.bondXmitHashPolicy = bondXmitHashPolicy;
        return (A)this;
    }

    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    public A withMacAddress(NetworkLinkEthernetMac macAddress) {
        this._visitables.remove("macAddress");
        if (macAddress != null) {
            this.macAddress = new NetworkLinkEthernetMacBuilder(macAddress);
            this._visitables.get("macAddress").add(this.macAddress);
        } else {
            this.macAddress = null;
            this._visitables.get("macAddress").remove(this.macAddress);
        }
        return (A)this;
    }

    public A withMtu(Integer mtu) {
        this.mtu = mtu;
        return (A)this;
    }

    public MacAddressNested<A> withNewMacAddress() {
        return new MacAddressNested(null);
    }

    public MacAddressNested<A> withNewMacAddressLike(NetworkLinkEthernetMac item) {
        return new MacAddressNested(item);
    }

    public class MacAddressNested<N>
    extends NetworkLinkEthernetMacFluent<MacAddressNested<N>>
    implements Nested<N> {
        NetworkLinkEthernetMacBuilder builder;

        MacAddressNested(NetworkLinkEthernetMac item) {
            this.builder = new NetworkLinkEthernetMacBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDataLinkBondFluent.this.withMacAddress(this.builder.build());
        }

        public N endMacAddress() {
            return this.and();
        }
    }
}

